/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization;

import com.google.common.collect.ImmutableList;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.security.AccessControlManager;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.version.VersionablePathHook;
import org.apache.jackrabbit.oak.security.authorization.AuthorizationContext;
import org.apache.jackrabbit.oak.security.authorization.AuthorizationInitializer;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlImporter;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlManagerImpl;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlValidatorProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionHook;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStoreValidatorProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidatorProvider;
import org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;

@Component
@Service(value={AuthorizationConfiguration.class, SecurityConfiguration.class})
public class AuthorizationConfigurationImpl
extends ConfigurationBase
implements AuthorizationConfiguration {
    public AuthorizationConfigurationImpl() {
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    public AuthorizationConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authorization"));
    }

    @Override
    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.authorization";
    }

    @Override
    public Context getContext() {
        return AuthorizationContext.getInstance();
    }

    @Override
    @Nonnull
    public WorkspaceInitializer getWorkspaceInitializer() {
        return new AuthorizationInitializer();
    }

    @Override
    @Nonnull
    public List<? extends CommitHook> getCommitHooks(String workspaceName) {
        return ImmutableList.of((Object)new VersionablePathHook(workspaceName), (Object)new PermissionHook(workspaceName, this.getRestrictionProvider()));
    }

    public List<ValidatorProvider> getValidators(String workspaceName, Set<Principal> principals, MoveTracker moveTracker) {
        return ImmutableList.of((Object)new PermissionStoreValidatorProvider(), (Object)new PermissionValidatorProvider(this.getSecurityProvider(), workspaceName, principals, moveTracker), (Object)new AccessControlValidatorProvider(this.getSecurityProvider()));
    }

    @Override
    @Nonnull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new AccessControlImporter());
    }

    @Override
    public AccessControlManager getAccessControlManager(Root root, NamePathMapper namePathMapper) {
        return new AccessControlManagerImpl(root, namePathMapper, this.getSecurityProvider());
    }

    @Override
    @Nonnull
    public RestrictionProvider getRestrictionProvider() {
        RestrictionProvider restrictionProvider = this.getParameters().getConfigValue("restrictionProvider", null, RestrictionProvider.class);
        if (restrictionProvider == null) {
            restrictionProvider = new RestrictionProviderImpl();
        }
        return restrictionProvider;
    }

    @Override
    @Nonnull
    public PermissionProvider getPermissionProvider(Root root, String workspaceName, Set<Principal> principals) {
        return new PermissionProviderImpl(root, workspaceName, principals, this);
    }
}

