/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.name.NamespaceConstants;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeDefinitionReader;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeUtil;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.util.Text;

class PrivilegeValidator
extends DefaultValidator
implements PrivilegeConstants {
    private final Root rootBefore;
    private final Root rootAfter;
    private final PrivilegeBitsProvider bitsProvider;

    PrivilegeValidator(Root before, Root after) {
        this.rootBefore = before;
        this.rootAfter = after;
        this.bitsProvider = new PrivilegeBitsProvider(this.rootBefore);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (!"rep:next".equals(before.getName())) {
            throw new CommitFailedException("Constraint", 45, "Attempt to modify existing privilege definition.");
        }
        this.validateNext(PrivilegeBits.getInstance(this.getPrivilegesTree(this.rootBefore).getProperty("rep:next")));
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        throw new CommitFailedException("Constraint", 46, "Attempt to modify existing privilege definition.");
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (PrivilegeValidator.isPrivilegeDefinition(after)) {
            this.getPrivilegesTree(this.rootBefore);
            if (NamespaceConstants.RESERVED_PREFIXES.contains(Text.getNamespacePrefix((String)name))) {
                String msg = "Failed to register custom privilege: Definition uses reserved namespace: " + name;
                throw new CommitFailedException("Privilege", 1, msg);
            }
            ImmutableTree tree = new ImmutableTree(ImmutableTree.ParentProvider.UNSUPPORTED, name, after);
            this.validateDefinition(tree);
        }
        return null;
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        if (PrivilegeValidator.isPrivilegeDefinition(before)) {
            throw new CommitFailedException("Constraint", 41, "Attempt to modify existing privilege definition " + name);
        }
        return null;
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (PrivilegeValidator.isPrivilegeDefinition(before)) {
            throw new CommitFailedException("Constraint", 42, "Attempt to un-register privilege " + name);
        }
        return null;
    }

    private void validateNext(PrivilegeBits bits) throws CommitFailedException {
        PrivilegeBits next = PrivilegeBits.getInstance(this.getPrivilegesTree(this.rootAfter).getProperty("rep:next"));
        if (!next.equals(bits.nextBits())) {
            throw new CommitFailedException("Constraint", 43, "Next bits not updated");
        }
    }

    @Nonnull
    private Tree getPrivilegesTree(Root root) throws CommitFailedException {
        Tree privilegesTree = root.getTree("/jcr:system/rep:privileges");
        if (!privilegesTree.exists()) {
            throw new CommitFailedException("Constraint", 44, "Privilege store not initialized.");
        }
        return privilegesTree;
    }

    private void validateDefinition(Tree definitionTree) throws CommitFailedException {
        PrivilegeBits newBits = PrivilegeBits.getInstance(definitionTree);
        if (newBits.isEmpty()) {
            throw new CommitFailedException("Constraint", 48, "PrivilegeBits are missing.");
        }
        Set<String> privNames = this.bitsProvider.getPrivilegeNames(newBits);
        PrivilegeDefinition definition = PrivilegeUtil.readDefinition(definitionTree);
        Set<String> declaredNames = definition.getDeclaredAggregateNames();
        if (declaredNames.isEmpty()) {
            if (!privNames.isEmpty()) {
                throw new CommitFailedException("Constraint", 49, "PrivilegeBits already in used.");
            }
            this.validateNext(newBits);
            return;
        }
        if (declaredNames.size() == 1) {
            throw new CommitFailedException("Constraint", 50, "Singular aggregation is equivalent to existing privilege.");
        }
        Map<String, PrivilegeDefinition> definitions = new PrivilegeDefinitionReader(this.rootBefore).readDefinitions();
        for (String aggrName : declaredNames) {
            if (!definitions.containsKey(aggrName)) {
                throw new CommitFailedException("Constraint", 51, "Declared aggregate '" + aggrName + "' is not a registered privilege.");
            }
            if (!PrivilegeValidator.isCircularAggregation(definition.getName(), aggrName, definitions)) continue;
            String msg = "Detected circular aggregation within custom privilege caused by " + aggrName;
            throw new CommitFailedException("Constraint", 52, msg);
        }
        Set<String> aggregateNames = PrivilegeValidator.resolveAggregates(declaredNames, definitions);
        for (PrivilegeDefinition existing : definitions.values()) {
            Set<String> existingDeclared = existing.getDeclaredAggregateNames();
            if (existingDeclared.isEmpty() || !declaredNames.equals(existingDeclared) && !aggregateNames.equals(PrivilegeValidator.resolveAggregates(existingDeclared, definitions))) continue;
            String msg = "Custom aggregate privilege '" + definition.getName() + "' is already covered by '" + existing.getName() + '\'';
            throw new CommitFailedException("Constraint", 53, msg);
        }
        PrivilegeBits aggrBits = this.bitsProvider.getBits(declaredNames.toArray(new String[declaredNames.size()]));
        if (!newBits.equals(aggrBits)) {
            throw new CommitFailedException("Constraint", 53, "Invalid privilege bits for aggregated privilege definition.");
        }
    }

    private static boolean isCircularAggregation(String privilegeName, String aggregateName, Map<String, PrivilegeDefinition> definitions) {
        if (privilegeName.equals(aggregateName)) {
            return true;
        }
        PrivilegeDefinition aggrPriv = definitions.get(aggregateName);
        if (aggrPriv.getDeclaredAggregateNames().isEmpty()) {
            return false;
        }
        boolean isCircular = false;
        for (String name : aggrPriv.getDeclaredAggregateNames()) {
            if (privilegeName.equals(name)) {
                return true;
            }
            if (!definitions.containsKey(name)) continue;
            isCircular = PrivilegeValidator.isCircularAggregation(privilegeName, name, definitions);
        }
        return isCircular;
    }

    private static Set<String> resolveAggregates(Set<String> declared, Map<String, PrivilegeDefinition> definitions) throws CommitFailedException {
        HashSet<String> aggregateNames = new HashSet<String>();
        for (String name : declared) {
            PrivilegeDefinition d = definitions.get(name);
            if (d == null) {
                throw new CommitFailedException("Constraint", 47, "Invalid declared aggregate name " + name + ": Unknown privilege.");
            }
            Set<String> names = d.getDeclaredAggregateNames();
            if (names.isEmpty()) {
                aggregateNames.add(name);
                continue;
            }
            aggregateNames.addAll(PrivilegeValidator.resolveAggregates(names, definitions));
        }
        return aggregateNames;
    }

    private static boolean isPrivilegeDefinition(@Nonnull NodeState state) {
        return "rep:Privilege".equals(NodeStateUtils.getPrimaryTypeName(state));
    }
}

