/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.user.AuthorizableBaseProvider;
import org.apache.jackrabbit.oak.security.user.MembershipWriter;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MembershipProvider
extends AuthorizableBaseProvider {
    private static final Logger log = LoggerFactory.getLogger(MembershipProvider.class);
    private final MembershipWriter writer = new MembershipWriter();

    MembershipProvider(Root root, ConfigurationParameters config) {
        super(root, config);
    }

    int getMembershipSizeThreshold() {
        return this.writer.getMembershipSizeThreshold();
    }

    void setMembershipSizeThreshold(int membershipSizeThreshold) {
        this.writer.setMembershipSizeThreshold(membershipSizeThreshold);
    }

    @Nonnull
    Iterator<String> getMembership(Tree authorizableTree, boolean includeInherited) {
        return this.getMembership(authorizableTree, includeInherited, new HashSet<String>());
    }

    @Nonnull
    private Iterator<String> getMembership(Tree authorizableTree, final boolean includeInherited, final Set<String> processedPaths) {
        final Iterable<String> refPaths = this.identifierManager.getReferences(true, authorizableTree, "rep:members", "rep:MemberReferences");
        return new AbstractLazyIterator<String>(){
            private final Iterator<String> references;
            private Iterator<String> parent;
            {
                this.references = refPaths.iterator();
            }

            protected String getNext() {
                String next = null;
                while (next == null) {
                    if (this.parent != null) {
                        if (this.parent.hasNext()) {
                            next = this.parent.next();
                            continue;
                        }
                        this.parent = null;
                        continue;
                    }
                    if (!this.references.hasNext()) break;
                    String propPath = this.references.next();
                    int index = propPath.indexOf("/rep:membersList");
                    if (index < 0) {
                        index = propPath.indexOf("/rep:members");
                    }
                    if (index > 0) {
                        Tree group;
                        String groupPath = propPath.substring(0, index);
                        if (!processedPaths.add(groupPath)) continue;
                        next = groupPath;
                        if (!includeInherited || !UserUtil.isType(group = MembershipProvider.this.getByPath(groupPath), AuthorizableType.GROUP)) continue;
                        this.parent = MembershipProvider.this.getMembership(group, true, processedPaths);
                        continue;
                    }
                    log.debug("Not a membership reference property " + propPath);
                }
                return next;
            }
        };
    }

    @Nonnull
    Iterator<String> getMembers(@Nonnull Tree groupTree, @Nonnull AuthorizableType authorizableType, boolean includeInherited) {
        return this.getMembers(groupTree, authorizableType, includeInherited, new HashSet<String>());
    }

    @Nonnull
    private Iterator<String> getMembers(final @Nonnull Tree groupTree, final @Nonnull AuthorizableType authorizableType, final boolean includeInherited, final @Nonnull Set<String> processedRefs) {
        return new AbstractLazyIterator<String>(){
            private MemberReferenceIterator references;
            private Iterator<String> parent;
            {
                this.references = new MemberReferenceIterator(groupTree, processedRefs);
            }

            protected String getNext() {
                String next = null;
                while (next == null) {
                    if (this.parent != null) {
                        if (this.parent.hasNext()) {
                            next = this.parent.next();
                            continue;
                        }
                        this.parent = null;
                        continue;
                    }
                    if (!this.references.hasNext()) break;
                    String value = (String)this.references.next();
                    next = MembershipProvider.this.identifierManager.getPath(PropertyValues.newWeakReference(value));
                    if (next == null || !includeInherited && authorizableType == AuthorizableType.AUTHORIZABLE) continue;
                    Tree auth = MembershipProvider.this.getByPath(next);
                    AuthorizableType type = UserUtil.getType(auth);
                    if (includeInherited && type == AuthorizableType.GROUP) {
                        this.parent = MembershipProvider.this.getMembers(auth, authorizableType, true, processedRefs);
                    }
                    if (authorizableType == AuthorizableType.AUTHORIZABLE || type == authorizableType) continue;
                    next = null;
                }
                return next;
            }
        };
    }

    boolean isMember(Tree groupTree, Tree authorizableTree, boolean includeInherited) {
        return this.isMember(groupTree, this.getContentID(authorizableTree), includeInherited);
    }

    boolean isMember(Tree groupTree, String contentId, boolean includeInherited) {
        if (includeInherited) {
            HashSet<String> refs = new HashSet<String>();
            Iterator<String> it = this.getMembers(groupTree, AuthorizableType.AUTHORIZABLE, includeInherited, refs);
            while (it.hasNext()) {
                it.next();
                if (!refs.contains(contentId)) continue;
                return true;
            }
        } else {
            MemberReferenceIterator refs = new MemberReferenceIterator(groupTree, new HashSet());
            while (refs.hasNext()) {
                if (!contentId.equals(refs.next())) continue;
                return true;
            }
        }
        return false;
    }

    boolean addMember(Tree groupTree, Tree newMemberTree) throws RepositoryException {
        return this.writer.addMember(groupTree, this.getContentID(newMemberTree));
    }

    boolean addMember(Tree groupTree, String memberContentId) throws RepositoryException {
        return this.writer.addMember(groupTree, memberContentId);
    }

    boolean removeMember(Tree groupTree, Tree memberTree) {
        if (this.writer.removeMember(groupTree, this.getContentID(memberTree))) {
            return true;
        }
        log.debug("Authorizable {} was not member of {}", (Object)memberTree.getName(), (Object)groupTree.getName());
        return false;
    }

    private class MemberReferenceIterator
    extends AbstractLazyIterator<String> {
        private final Set<String> processedRefs;
        private final Iterator<Tree> trees;
        private Iterator<String> propertyValues;

        private MemberReferenceIterator(@Nonnull Tree groupTree, Set<String> processedRefs) {
            this.processedRefs = processedRefs;
            this.trees = Iterators.concat((Iterator)Iterators.singletonIterator((Object)groupTree), groupTree.getChild("rep:membersList").getChildren().iterator());
        }

        protected String getNext() {
            String next = null;
            while (next == null) {
                if (this.propertyValues == null) {
                    if (!this.trees.hasNext()) break;
                    PropertyState property = this.trees.next().getProperty("rep:members");
                    if (property == null) continue;
                    this.propertyValues = property.getValue(Type.STRINGS).iterator();
                    continue;
                }
                if (!this.propertyValues.hasNext()) {
                    this.propertyValues = null;
                    continue;
                }
                String value = this.propertyValues.next();
                if (!this.processedRefs.add(value)) continue;
                next = value;
            }
            return next;
        }
    }
}

