/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.api.jmx.RepositoryStatsMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryStats
implements RepositoryStatsMBean {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryStats.class);
    private final RepositoryStatistics repoStats;
    private final TimeSeries maxQueueLength;
    public static final String[] ITEM_NAMES = new String[]{"per second", "per minute", "per hour", "per week"};

    public RepositoryStats(RepositoryStatistics repoStats, TimeSeries maxQueueLength) {
        this.repoStats = repoStats;
        this.maxQueueLength = maxQueueLength;
    }

    @Override
    public CompositeData getSessionCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_COUNT);
    }

    @Override
    public CompositeData getSessionLogin() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER);
    }

    @Override
    public CompositeData getSessionReadCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_COUNTER);
    }

    @Override
    public CompositeData getSessionReadDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_DURATION);
    }

    @Override
    public CompositeData getSessionReadAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_AVERAGE);
    }

    @Override
    public CompositeData getSessionWriteCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_COUNTER);
    }

    @Override
    public CompositeData getSessionWriteDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_DURATION);
    }

    @Override
    public CompositeData getSessionWriteAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_AVERAGE);
    }

    @Override
    public CompositeData getQueryCount() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_COUNT);
    }

    @Override
    public CompositeData getQueryDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_DURATION);
    }

    @Override
    public CompositeData getQueryAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_AVERAGE);
    }

    @Override
    public CompositeData getObservationEventCount() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_COUNTER);
    }

    @Override
    public CompositeData getObservationEventDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_DURATION);
    }

    @Override
    public CompositeData getObservationEventAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_AVERAGE);
    }

    @Override
    public CompositeData getObservationQueueMaxLength() {
        return RepositoryStats.asCompositeData(this.maxQueueLength, "maximal length of observation queue");
    }

    private TimeSeries getTimeSeries(RepositoryStatistics.Type type) {
        return this.repoStats.getTimeSeries(type);
    }

    private CompositeData asCompositeData(RepositoryStatistics.Type type) {
        return RepositoryStats.asCompositeData(this.getTimeSeries(type), type.name());
    }

    private static CompositeData asCompositeData(TimeSeries timeSeries, String name) {
        try {
            long[][] values = new long[][]{timeSeries.getValuePerSecond(), timeSeries.getValuePerMinute(), timeSeries.getValuePerHour(), timeSeries.getValuePerWeek()};
            return new CompositeDataSupport(RepositoryStats.getCompositeType(name), ITEM_NAMES, (Object[])values);
        }
        catch (Exception e) {
            LOG.error("Error creating CompositeData instance from TimeSeries", (Throwable)e);
            return null;
        }
    }

    private static CompositeType getCompositeType(String name) throws OpenDataException {
        ArrayType longArrayType = new ArrayType(SimpleType.LONG, true);
        OpenType[] itemTypes = new OpenType[]{longArrayType, longArrayType, longArrayType, longArrayType};
        return new CompositeType(name, name + " time series", ITEM_NAMES, ITEM_NAMES, itemTypes);
    }
}

