/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Header;
import org.jgroups.ViewId;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Util;

public class PingHeader
extends Header {
    public static final byte GET_MBRS_REQ = 1;
    public static final byte GET_MBRS_RSP = 2;
    public byte type = 0;
    public PingData data = null;
    public String cluster_name = null;
    public ViewId view_id = null;

    public PingHeader() {
    }

    public PingHeader(byte type, String cluster_name) {
        this.type = type;
        this.cluster_name = cluster_name;
    }

    public PingHeader(byte type, PingData data) {
        this.type = type;
        this.data = data;
    }

    public PingHeader(byte type, PingData data, String cluster_name) {
        this(type, data);
        this.cluster_name = cluster_name;
    }

    @Override
    public int size() {
        int retval = 3;
        if (this.data != null) {
            retval += this.data.size();
        }
        if (this.cluster_name != null) {
            retval += this.cluster_name.length() + 2;
        }
        return retval += Util.size(this.view_id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[PING: type=" + PingHeader.type2Str(this.type));
        if (this.cluster_name != null) {
            sb.append(", cluster=").append(this.cluster_name);
        }
        if (this.data != null) {
            sb.append(", arg=" + this.data);
        }
        if (this.view_id != null) {
            sb.append(", view_id=").append(this.view_id);
        }
        sb.append(']');
        return sb.toString();
    }

    static String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "GET_MBRS_REQ";
            }
            case 2: {
                return "GET_MBRS_RSP";
            }
        }
        return "<unkown type (" + t + ")>";
    }

    @Override
    public void writeTo(DataOutput outstream) throws Exception {
        outstream.writeByte(this.type);
        Util.writeStreamable(this.data, outstream);
        Util.writeString(this.cluster_name, outstream);
        Util.writeViewId(this.view_id, outstream);
    }

    @Override
    public void readFrom(DataInput instream) throws Exception {
        this.type = instream.readByte();
        this.data = (PingData)Util.readStreamable(PingData.class, instream);
        this.cluster_name = Util.readString(instream);
        this.view_id = Util.readViewId(instream);
    }
}

