/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.List;

public class IndexerRegistryUtil {
    private static IndexerRegistry _indexerRegistry;

    public static Indexer getIndexer(Class<?> clazz) {
        return IndexerRegistryUtil.getIndexerRegistry().getIndexer(clazz.getName());
    }

    public static Indexer getIndexer(String className) {
        return IndexerRegistryUtil.getIndexerRegistry().getIndexer(className);
    }

    public static IndexerRegistry getIndexerRegistry() {
        PortalRuntimePermission.checkGetBeanProperty(IndexerRegistryUtil.class);
        return _indexerRegistry;
    }

    public static List<Indexer> getIndexers() {
        return IndexerRegistryUtil.getIndexerRegistry().getIndexers();
    }

    public static Indexer nullSafeGetIndexer(Class<?> clazz) {
        return IndexerRegistryUtil.getIndexerRegistry().nullSafeGetIndexer(clazz.getName());
    }

    public static Indexer nullSafeGetIndexer(String className) {
        return IndexerRegistryUtil.getIndexerRegistry().nullSafeGetIndexer(className);
    }

    public static void register(Indexer indexer) {
        String[] stringArray = indexer.getClassNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            IndexerRegistryUtil.register(className, indexer);
            ++n2;
        }
        IndexerRegistryUtil.register(indexer.getClass().getName(), indexer);
    }

    public static void register(String className, Indexer indexer) {
        IndexerRegistryUtil.getIndexerRegistry().register(className, indexer);
    }

    public static void unregister(Indexer indexer) {
        String[] stringArray = indexer.getClassNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            IndexerRegistryUtil.unregister(className);
            ++n2;
        }
        IndexerRegistryUtil.unregister(indexer.getClass().getName());
    }

    public static void unregister(String className) {
        IndexerRegistryUtil.getIndexerRegistry().unregister(className);
    }

    public void setIndexerRegistry(IndexerRegistry indexerRegistry) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _indexerRegistry = indexerRegistry;
    }
}

