/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.exceptions;

import com.netflix.astyanax.connectionpool.exceptions.OperationException;

public class BadRequestException
extends OperationException {
    private static final long serialVersionUID = -6046784540431794568L;
    private static final String WHY_UNCONFIGURED_COLUMNFAMILY = "unconfigured columnfamily";
    private static final String KEYSPACE = "Keyspace";
    private static final String DOES_NOT_EXIST = "does not exist";

    public BadRequestException(String message) {
        super(message);
    }

    public BadRequestException(Throwable t) {
        super(t);
    }

    public BadRequestException(String message, Throwable cause) {
        super(message, cause);
    }

    public boolean isUnconfiguredColumnFamilyError() {
        return this.getMessage().contains(WHY_UNCONFIGURED_COLUMNFAMILY);
    }

    public boolean isKeyspaceDoestNotExist() {
        String message = this.getMessage();
        return message.contains(KEYSPACE) && message.contains(DOES_NOT_EXIST);
    }
}

