/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

import com.jhlabs.math.Function2D;
import java.util.Random;

public class WorleyFunction2D
implements Function2D {
    public double distancePower = 2.0;
    public boolean cells = false;
    public boolean angular = false;
    private int numPoints = 9;
    private double[] coefficients;
    private Random random;
    private Point[] results;

    public WorleyFunction2D() {
        double[] dArray = new double[4];
        dArray[0] = 1.0;
        this.coefficients = dArray;
        this.random = new Random();
        this.results = null;
        this.results = new Point[2];
        int n = 0;
        while (n < this.results.length) {
            this.results[n] = new Point();
            ++n;
        }
    }

    private double checkCube(double d, double d2, int n, int n2, Point[] pointArray) {
        this.random.setSeed(571 * n + 23 * n2);
        int n3 = 3 + this.random.nextInt() % 4;
        n3 = 4;
        int n4 = 0;
        while (n4 < n3) {
            double d3 = this.random.nextDouble();
            double d4 = this.random.nextDouble();
            double d5 = Math.abs(d - d3);
            double d6 = Math.abs(d2 - d4);
            double d7 = this.distancePower == 1.0 ? d5 + d6 : (this.distancePower == 2.0 ? Math.sqrt(d5 * d5 + d6 * d6) : Math.pow(Math.pow(d5, this.distancePower) + Math.pow(d6, this.distancePower), 1.0 / this.distancePower));
            int n5 = 0;
            while (n5 < pointArray.length) {
                Point point;
                if (pointArray[n5].distance == Double.POSITIVE_INFINITY) {
                    point = pointArray[n5];
                    point.distance = d7;
                    point.x = d3;
                    point.y = d4;
                    pointArray[n5] = point;
                    break;
                }
                if (d7 < pointArray[n5].distance) {
                    point = pointArray[pointArray.length - 1];
                    int n6 = pointArray.length - 1;
                    while (n6 > n5) {
                        pointArray[n6] = pointArray[n6 - 1];
                        --n6;
                    }
                    point.distance = d7;
                    point.x = d3;
                    point.y = d4;
                    pointArray[n5] = point;
                    break;
                }
                ++n5;
            }
            ++n4;
        }
        return pointArray[1].distance;
    }

    public double evaluate(double d, double d2) {
        int n = 0;
        while (n < this.results.length) {
            this.results[n].distance = Double.POSITIVE_INFINITY;
            ++n;
        }
        int n2 = (int)d;
        double d3 = d - (double)n2;
        int n3 = (int)d2;
        double d4 = d2 - (double)n3;
        double d5 = this.checkCube(d3, d4, n2, n3, this.results);
        if (d5 > d4) {
            d5 = this.checkCube(d3, d4 + 1.0, n2, n3 - 1, this.results);
        }
        if (d5 > 1.0 - d4) {
            d5 = this.checkCube(d3, d4 - 1.0, n2, n3 + 1, this.results);
        }
        if (d5 > d3) {
            this.checkCube(d3 + 1.0, d4, n2 - 1, n3, this.results);
            if (d5 > d4) {
                d5 = this.checkCube(d3 + 1.0, d4 + 1.0, n2 - 1, n3 - 1, this.results);
            }
            if (d5 > 1.0 - d4) {
                d5 = this.checkCube(d3 + 1.0, d4 - 1.0, n2 - 1, n3 + 1, this.results);
            }
        }
        if (d5 > 1.0 - d3) {
            d5 = this.checkCube(d3 - 1.0, d4, n2 + 1, n3, this.results);
            if (d5 > d4) {
                d5 = this.checkCube(d3 - 1.0, d4 + 1.0, n2 + 1, n3 - 1, this.results);
            }
            if (d5 > 1.0 - d4) {
                d5 = this.checkCube(d3 - 1.0, d4 - 1.0, n2 + 1, n3 + 1, this.results);
            }
        }
        double d6 = 0.0;
        int n4 = 0;
        while (n4 < 2) {
            d6 += this.coefficients[n4] * this.results[n4].distance;
            ++n4;
        }
        if (this.angular) {
            d6 += Math.atan2(d4 - this.results[0].y, d3 - this.results[0].x) / (Math.PI * 2) + 0.5;
        }
        return d6;
    }

    class Point {
        int index;
        double x;
        double y;
        double distance;

        Point() {
        }
    }
}

