/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadServiceUtil;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class DeleteThreadAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteThreads(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteThreads(actionRequest, true);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof LockedThreadException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            throw e2;
        }
    }

    protected void deleteThreads(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        String deleteEntryTitle = null;
        long[] deleteThreadIds = null;
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        deleteThreadIds = threadId > 0L ? new long[]{threadId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
        int i2 = 0;
        while (i2 < deleteThreadIds.length) {
            long deleteThreadId = deleteThreadIds[i2];
            if (moveToTrash) {
                MBThread thread = MBThreadServiceUtil.moveThreadToTrash((long)deleteThreadId);
                if (i2 == 0) {
                    MBMessage message = MBMessageLocalServiceUtil.getMessage((long)thread.getRootMessageId());
                    deleteEntryTitle = message.getSubject();
                }
            } else {
                MBThreadServiceUtil.deleteThread((long)deleteThreadId);
            }
            ++i2;
        }
        if (moveToTrash && deleteThreadIds.length > 0) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put("deleteEntryClassName", new String[]{MBThread.class.getName()});
            if (Validator.isNotNull((String)deleteEntryTitle)) {
                data.put("deleteEntryTitle", new String[]{deleteEntryTitle});
            }
            data.put("restoreThreadIds", ArrayUtil.toStringArray((long[])deleteThreadIds));
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }
}

