/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.workflow;

import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.workflow.Outcome;
import com.ecyrd.jspwiki.workflow.Step;
import com.ecyrd.jspwiki.workflow.Workflow;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStep
implements Step {
    private Date m_start = Workflow.TIME_NOT_SET;
    private Date m_end = Workflow.TIME_NOT_SET;
    private final String m_key;
    private boolean m_completed = false;
    private final Map<Outcome, Step> m_successors;
    private Workflow m_workflow;
    private Outcome m_outcome;
    private final List<String> m_errors = new ArrayList<String>();
    private boolean m_started = false;

    protected AbstractStep(String messageKey) {
        this.m_outcome = Outcome.STEP_CONTINUE;
        this.m_key = messageKey;
        this.m_successors = new LinkedHashMap<Outcome, Step>();
    }

    public AbstractStep(Workflow workflow, String messageKey) {
        this(messageKey);
        this.setWorkflow(workflow);
    }

    public final void addSuccessor(Outcome outcome, Step step) {
        this.m_successors.put(outcome, step);
    }

    public final Collection getAvailableOutcomes() {
        Set<Outcome> outcomes = this.m_successors.keySet();
        return Collections.unmodifiableCollection(outcomes);
    }

    public final List getErrors() {
        return Collections.unmodifiableList(this.m_errors);
    }

    public abstract Outcome execute() throws WikiException;

    public abstract Principal getActor();

    public final Date getEndTime() {
        return this.m_end;
    }

    public final Serializable[] getMessageArguments() {
        if (this.m_workflow == null) {
            return new Serializable[0];
        }
        return this.m_workflow.getMessageArguments();
    }

    public final String getMessageKey() {
        return this.m_key;
    }

    public final synchronized Outcome getOutcome() {
        return this.m_outcome;
    }

    public Principal getOwner() {
        if (this.m_workflow == null) {
            return null;
        }
        return this.m_workflow.getOwner();
    }

    public final Date getStartTime() {
        return this.m_start;
    }

    public final synchronized Workflow getWorkflow() {
        return this.m_workflow;
    }

    public final boolean isCompleted() {
        return this.m_completed;
    }

    public final boolean isStarted() {
        return this.m_started;
    }

    public final synchronized void setOutcome(Outcome outcome) {
        if (!(this.m_successors.containsKey(outcome) || Outcome.STEP_CONTINUE.equals(outcome) || Outcome.STEP_ABORT.equals(outcome))) {
            throw new IllegalArgumentException("Outcome " + outcome.getMessageKey() + " is not supported for this Step.");
        }
        if (outcome.isCompletion()) {
            if (this.m_completed) {
                throw new IllegalStateException("Step has already been marked complete; cannot set again.");
            }
            this.m_completed = true;
            this.m_end = new Date(System.currentTimeMillis());
        }
        this.m_outcome = outcome;
    }

    public final synchronized void start() throws WikiException {
        if (this.m_started) {
            throw new IllegalStateException("Step already started.");
        }
        this.m_started = true;
        this.m_start = new Date(System.currentTimeMillis());
    }

    public final Step getSuccessor(Outcome outcome) {
        return this.m_successors.get(outcome);
    }

    protected final synchronized void setWorkflow(Workflow workflow) {
        this.m_workflow = workflow;
    }

    protected final synchronized void addError(String message) {
        this.m_errors.add(message);
    }
}

