/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.lang.reflect.Field;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.meta.DbColumn;
import jodd.db.oom.meta.DbId;
import jodd.db.oom.meta.DbTable;
import jodd.db.oom.naming.ColumnNamingStrategy;
import jodd.db.oom.naming.TableNamingStrategy;
import jodd.db.type.SqlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMetaUtil {
    public static String resolveTableName(Class<?> type, TableNamingStrategy tableNamingStrategy) {
        String tableName = null;
        DbTable dbTable = type.getAnnotation(DbTable.class);
        if (dbTable != null) {
            tableName = dbTable.value().trim();
        }
        if (tableName == null || tableName.length() == 0) {
            tableName = tableNamingStrategy.convertEntityNameToTableName(type);
        } else if (!tableNamingStrategy.isStrictAnnotationNames()) {
            tableName = tableNamingStrategy.applyToTableName(tableName);
        }
        return tableName;
    }

    public static String resolveSchemaName(Class<?> type, String defaultSchemaName) {
        String schemaName = null;
        DbTable dbTable = type.getAnnotation(DbTable.class);
        if (dbTable != null) {
            schemaName = dbTable.schema().trim();
        }
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = defaultSchemaName;
        }
        return schemaName;
    }

    public static boolean resolveIsAnnotated(Class<?> type) {
        DbTable dbTable = type.getAnnotation(DbTable.class);
        return dbTable != null;
    }

    public static DbEntityColumnDescriptor resolveColumnDescriptors(DbEntityDescriptor dbEntityDescriptor, Field field, boolean isAnnotated, ColumnNamingStrategy columnNamingStrategy) {
        String columnName = null;
        boolean isId = false;
        Class<SqlType> sqlTypeClass = null;
        DbId dbId = field.getAnnotation(DbId.class);
        if (dbId != null) {
            columnName = dbId.value().trim();
            sqlTypeClass = dbId.sqlType();
            isId = true;
        } else {
            DbColumn dbColumn = field.getAnnotation(DbColumn.class);
            if (dbColumn != null) {
                columnName = dbColumn.value().trim();
                sqlTypeClass = dbColumn.sqlType();
            } else if (isAnnotated) {
                return null;
            }
        }
        if (columnName == null || columnName.length() == 0) {
            columnName = columnNamingStrategy.convertPropertyNameToColumnName(field.getName());
        } else if (!columnNamingStrategy.isStrictAnnotationNames()) {
            columnName = columnNamingStrategy.applyToColumnName(columnName);
        }
        if (sqlTypeClass == SqlType.class) {
            sqlTypeClass = null;
        }
        return new DbEntityColumnDescriptor(dbEntityDescriptor, columnName, field.getName(), field.getType(), isId, sqlTypeClass);
    }
}

