/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.Byte2ShortMap;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByte2ShortMap
implements Byte2ShortMap,
Serializable {
    protected short defRetValue;

    protected AbstractByte2ShortMap() {
    }

    @Override
    public void defaultReturnValue(short rv) {
        this.defRetValue = rv;
    }

    @Override
    public short defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public short put(byte key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short remove(byte key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short get(Object ok) {
        byte k = (Byte)ok;
        return this.containsKey(k) ? Short.valueOf(this.get(k)) : null;
    }

    @Override
    public Short put(Byte ok, Short ov) {
        byte k = ok;
        short v = this.put(k, (short)ov);
        return this.containsKey(k) ? Short.valueOf(v) : null;
    }

    @Override
    public Short remove(Object ok) {
        byte k = (Byte)ok;
        short v = this.remove(k);
        return this.containsKey(k) ? Short.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Short)ov);
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey((Byte)ok);
    }

    @Override
    public boolean containsValue(short v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(byte k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Short> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Byte, ? extends Short>> i = m.entrySet().iterator();
        if (m instanceof Byte2ShortMap) {
            while (n-- != 0) {
                Byte2ShortMap.Entry e = (Byte2ShortMap.Entry)i.next();
                this.put(e.getByteKey(), e.getShortValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Byte, ? extends Short> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet keySet() {
        return new AbstractByteSet(){

            public boolean contains(byte k) {
                return AbstractByte2ShortMap.this.containsKey(k);
            }

            public int size() {
                return AbstractByte2ShortMap.this.size();
            }

            public void clear() {
                AbstractByte2ShortMap.this.clear();
            }

            public ByteIterator iterator() {
                return new AbstractByteIterator(){
                    final ObjectIterator<Map.Entry<Byte, Short>> i;
                    {
                        this.i = AbstractByte2ShortMap.this.entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Byte2ShortMap.Entry)this.i.next()).getByteKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ShortCollection values() {
        return new AbstractShortCollection(){

            public boolean contains(short k) {
                return AbstractByte2ShortMap.this.containsValue(k);
            }

            public int size() {
                return AbstractByte2ShortMap.this.size();
            }

            public void clear() {
                AbstractByte2ShortMap.this.clear();
            }

            public ShortIterator iterator() {
                return new AbstractShortIterator(){
                    final ObjectIterator<Map.Entry<Byte, Short>> i;
                    {
                        this.i = AbstractByte2ShortMap.this.entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Byte2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Byte, Short>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Byte, Short>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Byte2ShortMap.Entry e = (Byte2ShortMap.Entry)i.next();
            s.append(String.valueOf(e.getByteKey()));
            s.append("=>");
            s.append(String.valueOf(e.getShortValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Byte2ShortMap.Entry {
        protected byte key;
        protected short value;

        public BasicEntry(Byte key, Short value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(byte key, short value) {
            this.key = key;
            this.value = value;
        }

        public Byte getKey() {
            return this.key;
        }

        public byte getByteKey() {
            return this.key;
        }

        public Short getValue() {
            return this.value;
        }

        public short getShortValue() {
            return this.value;
        }

        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        public Short setValue(Short value) {
            return this.setValue((short)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Byte)e.getKey() && this.value == (Short)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

