/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.sharing;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceMessage
implements WorkspaceMessage {
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessage.class);
    private final JCRWorkspace workspace;
    private final ItemDelegate messageItem;
    private final WorkspaceMessageType type;
    private List<String> copyAttachmentIds;
    private boolean isRead;
    private boolean isOpened;

    public JCRWorkspaceMessage(JCRWorkspace workspace, ItemDelegate messageItem, WorkspaceMessageType type) throws javax.jcr.RepositoryException {
        this.workspace = workspace;
        this.messageItem = messageItem;
        this.type = type;
        this.isRead = (Boolean)new XStream().fromXML((String)messageItem.getProperties().get(NodeProperty.READ));
        this.isOpened = (Boolean)new XStream().fromXML((String)messageItem.getProperties().get(NodeProperty.OPEN));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JCRWorkspaceMessage(JCRWorkspace workspace, ItemDelegate messageItem, WorkspaceMessageType type, String messageId, String subject, String body, User sender, List<String> attachmentIds, List<String> addresses, String user) throws javax.jcr.RepositoryException, InternalErrorException {
        this.workspace = workspace;
        this.messageItem = messageItem;
        this.type = type;
        this.copyAttachmentIds = new ArrayList<String>();
        this.isRead = false;
        this.isOpened = false;
        HashMap<NodeProperty, String> properties = new HashMap<NodeProperty, String>();
        properties.put(NodeProperty.SUBJECT, subject);
        properties.put(NodeProperty.BODY, body);
        properties.put(NodeProperty.READ, new XStream().toXML((Object)false));
        properties.put(NodeProperty.OPEN, new XStream().toXML((Object)false));
        HashMap<NodeProperty, String> owner = new HashMap<NodeProperty, String>();
        owner.put(NodeProperty.USER_ID, sender.getId());
        owner.put(NodeProperty.PORTAL_LOGIN, sender.getPortalLogin());
        properties.put(NodeProperty.OWNER, new XStream().toXML(owner));
        properties.put(NodeProperty.ADDRESSES, new XStream().toXML(addresses));
        properties.put(NodeProperty.ATTACHMENTS_ID, new XStream().toXML(attachmentIds));
        messageItem.setProperties(properties);
        JCRSession servlets = null;
        String rootAttachmentsId = null;
        try {
            servlets = new JCRSession(workspace.getOwner().getPortalLogin(), false);
            ItemDelegate saved = servlets.saveItem(messageItem);
            rootAttachmentsId = (String)saved.getProperties().get(NodeProperty.ATTACHMENTS_ID);
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving attachments id" + e.getMessage());
        }
        LinkedList<User> users = new LinkedList<User>();
        for (String address : addresses) {
            User user1 = workspace.getHome().getHomeManager().getUser(address);
            if (user1 == null) continue;
            users.add(user1);
        }
        try {
            logger.debug("attachmentIds.size() " + attachmentIds.size());
            for (String attachmentId : attachmentIds) {
                ItemDelegate nodeItem = servlets.getItemById(attachmentId);
                JCRWorkspaceItem item = workspace.getWorkspaceItem(nodeItem);
                if (!item.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) continue;
                try {
                    logger.debug("nodeItem.getName() " + nodeItem.getName());
                    ItemDelegate newNode = item.internalCopy(servlets, servlets.getItemById(rootAttachmentsId), nodeItem.getName(), false);
                    logger.debug("Set owner of attachment " + nodeItem.getName() + " to user " + user + " - " + type.toString());
                    newNode.setOwner(user);
                    if (this.type.equals((Object)WorkspaceMessageType.SENT)) {
                        workspace.copyRemoteContent(servlets, newNode, null);
                        logger.debug("add new id to copyAttachmentIds " + newNode.getId());
                        this.copyAttachmentIds.add(newNode.getId());
                    } else if (this.type.equals((Object)WorkspaceMessageType.RECEIVED)) {
                        String hardLinkRemotePath = messageItem.getPath() + "/" + nodeItem.getName();
                        workspace.setHardLink(newNode, hardLinkRemotePath);
                    }
                    servlets.saveItem(newNode);
                    workspace.fireItemSentEvent(item, users);
                }
                catch (ItemAlreadyExistException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (WrongDestinationException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (RepositoryException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (ItemNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                    return;
                }
            }
        }
        catch (ItemNotFoundException | RepositoryException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public String getId() {
        return this.messageItem.getName();
    }

    public User getSender() {
        return new JCRUser(this.messageItem.getOwner(), this.messageItem.getOwner());
    }

    public Calendar getSendTime() {
        return this.messageItem.getCreationTime();
    }

    public String getSubject() {
        return (String)this.messageItem.getProperties().get(NodeProperty.SUBJECT);
    }

    public String getBody() {
        return (String)this.messageItem.getProperties().get(NodeProperty.BODY);
    }

    public List<String> getAttachmentsIds() {
        return (List)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
    }

    public List<String> getCopyAttachmentsIds() {
        return this.copyAttachmentIds;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void open() throws InternalErrorException {
        this.isOpened = true;
        JCRSession servlets = null;
        ItemDelegate root = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            switch (this.type) {
                case RECEIVED: {
                    root = this.workspace.getRepository().getOwnInBoxFolder();
                    break;
                }
                case SENT: {
                    root = this.workspace.getRepository().getOutBoxFolder();
                }
            }
            DelegateManager manager = new DelegateManager(root, this.workspace.getOwner().getPortalLogin());
            ItemDelegate node = manager.getNode(this.getId());
            node.getProperties().put(NodeProperty.OPEN, new XStream().toXML((Object)true));
            servlets.saveItem(node);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    public void setStatus(boolean status) throws InternalErrorException {
        this.isRead = status;
        JCRSession servlets = null;
        ItemDelegate root = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            switch (this.type) {
                case RECEIVED: {
                    root = this.workspace.getRepository().getOwnInBoxFolder();
                    break;
                }
                case SENT: {
                    root = this.workspace.getRepository().getOutBoxFolder();
                }
            }
            DelegateManager manager = new DelegateManager(root, this.workspace.getOwner().getPortalLogin());
            ItemDelegate node = manager.getNode(this.getId());
            node.getProperties().put(NodeProperty.READ, new XStream().toXML((Object)status));
            servlets.saveItem(node);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    public void saveAttachments(String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        JCRSession servlets = null;
        try {
            WorkspaceFolder folder;
            ItemDelegate folderNode;
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            try {
                folderNode = servlets.getItemById(destinationFolderId);
                folder = (WorkspaceFolder)this.workspace.getItem(destinationFolderId);
            }
            catch (Exception e) {
                throw new WrongDestinationException(e.getMessage());
            }
            List attachs = (List)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
            for (String attachmentId : attachs) {
                this.saveAttachment(attachmentId, folder, folderNode);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public WorkspaceItem saveAttachment(String attachmentId, String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        WorkspaceFolder folder;
        ItemDelegate folderNode;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            folderNode = servlets.getItemById(destinationFolderId);
            folder = (WorkspaceFolder)this.workspace.getItem(destinationFolderId);
        }
        catch (Exception e) {
            throw new WrongDestinationException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
        return this.saveAttachment(attachmentId, folder, folderNode);
    }

    private WorkspaceItem saveAttachment(String attachmentId, WorkspaceFolder folder, ItemDelegate folderNode) throws ItemNotFoundException, WrongDestinationException, InternalErrorException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
            ItemDelegate attachment = servlets.getItemById(attachmentId);
            String name = folder.getUniqueName(attachment.getTitle(), false);
            String pathDestination = folderNode.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)name);
            try {
                servlets.copy(attachment.getPath(), pathDestination, false);
            }
            catch (HttpException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
            ItemDelegate itemSaved = servlets.getItemByPath(pathDestination);
            itemSaved.setOwner(this.workspace.getOwner().getPortalLogin());
            itemSaved.setTitle(name);
            this.workspace.copyRemoteContent(servlets, itemSaved, folderNode);
            servlets.saveItem(itemSaved);
            WorkspaceItem workspaceItem = this.workspace.getItem(itemSaved.getId());
            return workspaceItem;
        }
        catch (RepositoryException | RemoteBackendException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public List<WorkspaceItem> getAttachments() throws InternalErrorException {
        LinkedList<WorkspaceItem> list = new LinkedList<WorkspaceItem>();
        try {
            List attachs = (List)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
            for (String id : attachs) {
                list.add(this.workspace.getItem(id));
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public List<String> getAddresses() {
        return (List)new XStream().fromXML((String)this.messageItem.getProperties().get(NodeProperty.ADDRESSES));
    }

    public static enum WorkspaceMessageType {
        RECEIVED,
        SENT;

    }
}

