/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AccessControlListener;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;

public abstract class AccessControlObserver
implements SynchronousEventListener {
    public static final int POLICY_ADDED = 1;
    public static final int POLICY_REMOVED = 2;
    public static final int POLICY_MODIFIED = 4;
    private final Set<AccessControlListener> listeners = new HashSet<AccessControlListener>();
    private final Object listenerMonitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Object object = this.listenerMonitor;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AccessControlListener listener) {
        Object object = this.listenerMonitor;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AccessControlListener listener) {
        Object object = this.listenerMonitor;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(AccessControlModifications modifications) {
        AccessControlListener[] lstnrs;
        Object object = this.listenerMonitor;
        synchronized (object) {
            lstnrs = this.listeners.toArray(new AccessControlListener[this.listeners.size()]);
        }
        for (AccessControlListener lstnr : lstnrs) {
            lstnr.acModified(modifications);
        }
    }
}

