/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.AccessType;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.Encrypter;
import org.gcube.contentmanagement.blobstorage.service.impl.AmbiguousResource;
import org.gcube.contentmanagement.blobstorage.service.impl.LocalResource;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResource;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResourceBoolean;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResourceComplexInfo;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResourceFolderInfo;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResourceInfo;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResourceSource;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.operation.OperationManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEngine
implements IClient {
    final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    public String[] primaryBackend;
    public String[] volatileBackend;
    protected OperationManager service;
    protected MyFile file;
    protected String bucket;
    protected String bucketID;
    protected String author;
    protected String owner;
    protected String environment;
    protected String currentOperation;
    protected boolean replaceOption;
    protected String publicArea;
    protected String homeArea;
    protected Map<String, String> attributes;
    private AccessType accessType;
    private String serviceName;
    private String ownerGcube;
    private String gcubeScope;
    private AccessType gcubeAccessType;
    private MemoryType gcubeMemoryType;
    private String serviceClass;
    private String backendType;
    private String user;
    private String password;
    private String passPhrase;
    private String resolverHost;
    private String[] dbNames;
    private String write;
    private String read;

    public ServiceEngine(String[] server) {
        this.primaryBackend = server;
    }

    public ServiceEngine(String[] server, String environment, String accessType, String owner) {
        this.primaryBackend = server;
        this.setOwner(owner);
        this.setEnvironment(environment);
        this.setAccessType(accessType);
        if (accessType.equalsIgnoreCase("public")) {
            this.setPublicArea("/" + this.getEnvironment() + "/" + "public" + "/");
        } else {
            this.setPublicArea("/" + this.getEnvironment() + "/");
        }
        this.setHomeArea("/" + this.getEnvironment() + "/");
    }

    public ServiceEngine(String[] server, String[] volatileBackend, String environment, String accessType, String owner, String memory) {
        if (memory.equals(MemoryType.VOLATILE.toString()) && volatileBackend[0] != null) {
            this.primaryBackend = volatileBackend;
        } else if (memory.equals(MemoryType.VOLATILE.toString()) && volatileBackend[0] == null) {
            this.primaryBackend = server;
            this.volatileBackend = null;
        } else {
            this.primaryBackend = server;
            this.volatileBackend = volatileBackend;
        }
        this.setOwner(owner);
        this.setEnvironment(environment);
        this.setAccessType(accessType);
        if (accessType.equalsIgnoreCase("public")) {
            this.setPublicArea("/" + this.getEnvironment() + "/" + "public" + "/");
        } else {
            this.setPublicArea("/" + this.getEnvironment() + "/");
        }
        this.setHomeArea("/" + this.getEnvironment() + "/");
    }

    @Deprecated
    public ServiceEngine(String[] server, String id, String environment, String scope, String owner) {
        this.primaryBackend = server;
        this.setOwner(owner);
        this.setEnvironment(environment);
        this.setAccessType(scope);
        this.setPublicArea("/" + environment);
        this.setHomeArea("/" + environment);
    }

    public String getPublicArea() {
        return this.publicArea;
    }

    public void setPublicArea(String publicArea) {
        this.logger.trace("public area is " + publicArea);
        this.publicArea = publicArea;
    }

    public String getHomeArea() {
        return this.homeArea;
    }

    public void setHomeArea(String rootPath) {
        this.homeArea = rootPath;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        String newEnv = environment;
        int ind = newEnv.indexOf(47);
        while (ind == 0) {
            environment = newEnv = environment.substring(1);
            ind = newEnv.indexOf(47);
        }
        this.environment = newEnv;
    }

    public String getBucketID() {
        return this.bucketID;
    }

    public void setBucketID(String bucketID) {
        this.bucketID = bucketID;
    }

    @Override
    public LocalResource get() {
        return this.get("MongoDB");
    }

    @Override
    public LocalResource get(String backendType) {
        this.file = null;
        backendType = this.setBackendType(backendType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("download");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.DOWNLOAD);
        return new LocalResource(this.file, this);
    }

    @Override
    public RemoteResourceInfo getSize() {
        return this.getSize("MongoDB");
    }

    @Override
    public RemoteResourceInfo getSize(String backendType) {
        this.file = null;
        backendType = this.setBackendType(backendType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getSize");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_SIZE);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResourceComplexInfo getMetaFile() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getMetaFile");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_META_FILE);
        return new RemoteResourceComplexInfo(this.file, this);
    }

    @Override
    public String getTotalUserVolume() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getTotalUserVolume");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_TOTAL_USER_VOLUME);
        this.file = new Resource(this.file, this).setGenericProperties(this.getContext(), this.owner, null, "remote");
        this.file.setRemotePath("/");
        this.file.setOwner(this.owner);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.setMyFile(this.file);
        this.service.setResource(this.getMyFile());
        String info = null;
        try {
            if (this.file.getInputStream() != null || this.file.getOutputStream() != null || this.file.getLocalPath() != null || this.file.getRemotePath() != null) {
                info = (String)this.service.startOperation(this.file, this.file.getRemotePath(), this.owner, this.primaryBackend, false, this.getContext(), this.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.currentOperation + " operation ", t.getCause());
        }
        if (info != null) {
            return info.toString();
        }
        return null;
    }

    @Override
    public String getUserTotalItems() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getTotalUserItems");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_USER_TOTAL_ITEMS);
        this.file = new Resource(this.file, this).setGenericProperties(this.getContext(), this.owner, "", "remote");
        this.file.setRemotePath("/");
        this.file.setOwner(this.owner);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.setMyFile(this.file);
        this.service.setResource(this.getMyFile());
        String info = null;
        try {
            if (this.file.getInputStream() != null || this.file.getOutputStream() != null || this.file.getLocalPath() != null || this.file.getRemotePath() != null) {
                info = (String)this.service.startOperation(this.file, this.file.getRemotePath(), this.owner, this.primaryBackend, false, this.getContext(), this.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.currentOperation + " operation ", t.getCause());
        }
        if (info != null) {
            return info.toString();
        }
        return null;
    }

    @Override
    public RemoteResourceFolderInfo getFolderTotalVolume() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getFolderSize");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_FOLDER_TOTAL_VOLUME);
        return new RemoteResourceFolderInfo(this.file, this);
    }

    @Override
    public RemoteResourceFolderInfo getFolderTotalItems() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getFolderCount");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_FOLDER_TOTAL_ITEMS);
        return new RemoteResourceFolderInfo(this.file, this);
    }

    @Override
    public RemoteResourceFolderInfo getFolderLastUpdate() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getFolderLastUpdate");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_FOLDER_LAST_UPDATE);
        return new RemoteResourceFolderInfo(this.file, this);
    }

    @Override
    public LocalResource put(boolean replace) {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("upload");
        this.setReplaceOption(replace);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), this.backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.UPLOAD);
        this.file.setReplaceOption(replace);
        return new LocalResource(this.file, this);
    }

    @Override
    public LocalResource put(boolean replace, String mimeType) {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("upload");
        this.setReplaceOption(replace);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), this.backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.UPLOAD);
        this.file = this.setMimeType(this.file, mimeType);
        this.file.setReplaceOption(replace);
        return new LocalResource(this.file, this);
    }

    @Override
    public RemoteResource remove() {
        return this.remove("MongoDB");
    }

    @Override
    public RemoteResource remove(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("remove");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.REMOVE);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        return new RemoteResource(this.file, this);
    }

    public MyFile getMyFile() {
        return this.file;
    }

    public void setMyFile(MyFile myFile) {
        this.file = myFile;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Override
    public RemoteResource showDir() {
        return this.showDir("MongoDB");
    }

    @Override
    public RemoteResource showDir(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("showDir");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.SHOW_DIR);
        return new RemoteResource(this.file, this);
    }

    List<StorageObject> addObjectsDirBucket(Map<String, StorageObject> mapDirs) {
        Set<String> dirsKeys = mapDirs.keySet();
        ArrayList<StorageObject> dirs = new ArrayList<StorageObject>(dirsKeys.size());
        for (String key : dirsKeys) {
            key = new BucketCoding().bucketDirDecoding(key, this.getContext());
            this.logger.debug("add " + key);
            dirs.add(mapDirs.get(key));
        }
        return dirs;
    }

    @Override
    public RemoteResource removeDir() {
        return this.removeDir("MongoDB");
    }

    @Override
    public RemoteResource removeDir(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("removedir");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.REMOVE_DIR);
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResource getUrl() {
        return this.getUrl("MongoDB");
    }

    @Override
    public RemoteResource getUrl(boolean forceCreation) {
        return this.getUrl("MongoDB", forceCreation);
    }

    @Override
    public RemoteResource getUrl(String backendType) {
        return this.getUrl(backendType, false);
    }

    @Override
    public RemoteResource getUrl(String backendType, boolean forceCreation) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.file.setResolverHost(this.getResolverHost());
        this.file.forceCreation(forceCreation);
        this.file.setPassPhrase(this.passPhrase);
        this.setCurrentOperation("getUrl");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_URL);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        RemoteResource resource = new RemoteResource(this.file, this);
        return resource;
    }

    @Override
    public RemoteResource getHttpUrl() {
        return this.getHttpUrl("MongoDB");
    }

    @Override
    public RemoteResource getHttpUrl(boolean forceCreation) {
        return this.getHttpUrl("MongoDB", forceCreation);
    }

    @Override
    public RemoteResource getHttpUrl(String backendType) {
        return this.getHttpUrl(backendType, false);
    }

    @Override
    public RemoteResource getHttpUrl(String backendType, boolean forceCreation) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.file.setResolverHost(this.getResolverHost());
        this.file.forceCreation(forceCreation);
        this.file.setPassPhrase(this.passPhrase);
        this.setCurrentOperation("getHttpUrl");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_HTTP_URL);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        RemoteResource resource = new RemoteResource(this.file, this);
        return resource;
    }

    @Override
    public RemoteResource getHttpsUrl() {
        return this.getHttpsUrl("MongoDB");
    }

    @Override
    public RemoteResource getHttpsUrl(boolean forceCreation) {
        return this.getHttpsUrl("MongoDB", forceCreation);
    }

    @Override
    public RemoteResource getHttpsUrl(String backendType) {
        return this.getHttpsUrl(backendType, false);
    }

    @Override
    public RemoteResource getHttpsUrl(String backendType, boolean forceCreation) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.file.setResolverHost(this.getResolverHost());
        this.file.forceCreation(forceCreation);
        this.file.setPassPhrase(this.passPhrase);
        this.setCurrentOperation("getHttpsUrl");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_HTTPS_URL);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        RemoteResource resource = new RemoteResource(this.file, this);
        return resource;
    }

    public String getContext() {
        if (this.isPublic()) {
            return this.getPublicArea();
        }
        return this.getHomeArea();
    }

    public boolean isPublic() {
        if (this.getScope() != null) {
            return this.getScope().equalsIgnoreCase("public");
        }
        return "private".equalsIgnoreCase("public");
    }

    public String getScope() {
        return this.accessType.toString();
    }

    public String getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
    }

    public boolean isReplaceOption() {
        return this.replaceOption;
    }

    public void setReplaceOption(boolean replaceOption) {
        this.replaceOption = replaceOption;
    }

    @Override
    public AmbiguousResource lock() {
        return this.lock("MongoDB");
    }

    public AmbiguousResource lock(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(true);
        this.setCurrentOperation("lock");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.LOCK);
        return new AmbiguousResource(this.file, this);
    }

    @Override
    public AmbiguousResource unlock(String key) {
        return this.unlock(key, "MongoDB");
    }

    @Override
    public AmbiguousResource unlock(String key, String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setLockedKey(key);
        this.setCurrentOperation("unlock");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.UNLOCK);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        return new AmbiguousResource(this.file, this);
    }

    @Override
    public RemoteResourceInfo getTTL() {
        return this.getTTL("MongoDB");
    }

    @Override
    public RemoteResourceInfo getTTL(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.setCurrentOperation("getTTL");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_TTL);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResource getMetaInfo(String field) {
        return this.getMetaInfo(field, "MongoDB");
    }

    @Override
    public RemoteResource getMetaInfo(String field, String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setGenericPropertyField(field);
        this.setCurrentOperation("getMetaInfo");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_META_INFO);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResource setMetaInfo(String field, String value) {
        return this.setMetaInfo(field, value, "MongoDB");
    }

    @Override
    public RemoteResource setMetaInfo(String field, String value, String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setGenericPropertyField(field);
        this.file.setGenericPropertyValue(value);
        this.setCurrentOperation("setMetaInfo");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.SET_META_INFO);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResourceInfo renewTTL(String key) {
        return this.renewTTL(key, "MongoDB");
    }

    @Override
    public RemoteResourceInfo renewTTL(String key, String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.file.setLockedKey(key);
        this.setCurrentOperation("renewTTL");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.RENEW_TTL);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResourceSource linkFile() {
        return this.linkFile("MongoDB");
    }

    @Override
    public RemoteResourceSource linkFile(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        this.setCurrentOperation("link");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.LINK);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType, this.getDbNames());
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource copyFile() {
        return this.copyFile("MongoDB", false);
    }

    @Override
    public RemoteResourceSource copyFile(String backendType) {
        return this.copyFile(backendType, false);
    }

    @Override
    public RemoteResourceSource copyFile(boolean replaceOption) {
        return this.copyFile("MongoDB", replaceOption);
    }

    @Override
    public RemoteResourceSource copyFile(String backendType, boolean replaceOption) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        this.setCurrentOperation("copy");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.COPY);
        this.file.setReplaceOption(replaceOption);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType, this.getDbNames());
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResource duplicateFile() {
        return this.duplicateFile("MongoDB");
    }

    @Override
    public RemoteResource duplicateFile(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        this.setCurrentOperation("duplicate");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.DUPLICATE);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType, this.getDbNames());
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResourceSource softCopy() {
        return this.softCopy("MongoDB", false);
    }

    @Override
    public RemoteResourceSource softCopy(String backendType) {
        return this.softCopy(backendType, false);
    }

    @Override
    public RemoteResourceSource softCopy(boolean replaceOption) {
        return this.softCopy("MongoDB", replaceOption);
    }

    @Override
    public RemoteResourceSource softCopy(String backendType, boolean replaceOption) {
        this.file = null;
        this.setCurrentOperation("softcopy");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.SOFT_COPY);
        this.file.setReplaceOption(replaceOption);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType, this.getDbNames());
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource moveFile() {
        return this.moveFile("MongoDB");
    }

    @Override
    public RemoteResourceSource moveFile(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        this.setCurrentOperation("move");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.MOVE);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType, this.getDbNames());
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource copyDir() {
        return this.copyDir("MongoDB");
    }

    @Override
    public RemoteResourceSource copyDir(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        this.setCurrentOperation("copy_dir");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.COPY_DIR);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType, this.getDbNames());
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource moveDir() {
        return this.moveDir("MongoDB");
    }

    @Override
    public RemoteResourceSource moveDir(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        this.setCurrentOperation("move_dir");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.MOVE_DIR);
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType, this.getDbNames());
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public void close() {
        this.currentOperation = "close";
        this.file.setOwner(this.owner);
        this.getMyFile().setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH);
        this.setMyFile(this.file);
        this.service.setResource(this.getMyFile());
        this.service.setTypeOperation("close");
        try {
            if (this.file.getInputStream() != null || this.file.getOutputStream() != null || this.file.getLocalPath() != null || this.file.getRemotePath() != null) {
                this.service.startOperation(this.file, this.file.getRemotePath(), this.owner, this.primaryBackend, false, this.getContext(), this.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Throwable t) {
            this.logger.error("get()", t.getCause());
            throw new RemoteBackendException(" Error in " + this.currentOperation + " operation ", t.getCause());
        }
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getOwnerGcube() {
        return this.ownerGcube;
    }

    public void setOwnerGcube(String ownerGcube) {
        this.ownerGcube = ownerGcube;
    }

    public String getGcubeScope() {
        return this.gcubeScope;
    }

    public void setGcubeScope(String gcubeScope) {
        this.gcubeScope = gcubeScope;
    }

    public AccessType getGcubeAccessType() {
        return this.gcubeAccessType;
    }

    public void setGcubeAccessType(String gcubeAccessType) {
        if (gcubeAccessType.equals(AccessType.PUBLIC.toString())) {
            this.gcubeAccessType = AccessType.PUBLIC;
        } else if (gcubeAccessType.equals(AccessType.SHARED.toString())) {
            this.gcubeAccessType = AccessType.SHARED;
        } else if (gcubeAccessType.equals(AccessType.PRIVATE.toString())) {
            this.gcubeAccessType = AccessType.PRIVATE;
        } else {
            throw new RuntimeException("invalid AccessType");
        }
    }

    public MemoryType getGcubeMemoryType() {
        return this.gcubeMemoryType;
    }

    public void setGcubeMemoryType(String gcubeMemoryType) {
        if (gcubeMemoryType.equals(MemoryType.PERSISTENT.toString())) {
            this.gcubeMemoryType = MemoryType.PERSISTENT;
        } else if (gcubeMemoryType.equals(MemoryType.VOLATILE.toString())) {
            this.gcubeMemoryType = MemoryType.VOLATILE;
        } else if (gcubeMemoryType.equals(MemoryType.BOTH.toString())) {
            this.gcubeMemoryType = MemoryType.BOTH;
        } else {
            throw new RuntimeException("invalid MemoryType");
        }
    }

    private MyFile setOperationInfo(MyFile file, OperationDefinition.OPERATION op) {
        if (file == null) {
            file = new MyFile(this.getGcubeMemoryType());
        }
        file.setOperation(op);
        if (this.getWriteConcern() != null) {
            file.setWriteConcern(this.getWriteConcern());
        }
        if (this.getReadConcern() != null) {
            file.setReadPreference(this.getReadConcern());
        }
        return file;
    }

    private MyFile setMimeType(MyFile file, String mime) {
        if (file == null) {
            file = new MyFile(this.getGcubeMemoryType());
        }
        file.setMimeType(mime);
        return file;
    }

    public String setBackendType(String backendType) {
        if (backendType != null) {
            this.backendType = backendType;
        }
        return this.backendType;
    }

    public String getBackendType() {
        return this.backendType;
    }

    public String getBackendUser() {
        return this.user;
    }

    public void setBackendUser(String user) {
        if (user != null) {
            this.user = user;
        }
    }

    public String getBackendPassword() {
        return this.password;
    }

    public void setBackendPassword(String password) {
        if (password != null) {
            this.password = password;
        }
    }

    public void setResolverHost(String resolverHost) {
        this.resolverHost = resolverHost;
    }

    public String getResolverHost() {
        if (this.resolverHost != null) {
            return this.resolverHost;
        }
        return "data.d4science.org";
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    @Override
    public String getId(String id) {
        if (ObjectId.isValid((String)id)) {
            return id;
        }
        try {
            if (Base64.isBase64((String)id)) {
                byte[] valueDecoded = Base64.decodeBase64((String)id);
                String encryptedID = new String(valueDecoded);
                return new Encrypter("DES", this.getPassPhrase()).decrypt(encryptedID);
            }
            return new Encrypter("DES", this.getPassPhrase()).decrypt(id);
        }
        catch (Encrypter.EncryptionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public RemoteResource getRemotePath() {
        this.backendType = this.setBackendType(this.backendType);
        this.file = new MyFile(this.getGcubeMemoryType());
        this.setCurrentOperation("getRemotePath");
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.GET_REMOTE_PATH);
        this.file.setRootPath(this.getPublicArea());
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType, this.getDbNames());
        return new RemoteResource(this.file, this);
    }

    public String getWriteConcern() {
        return this.write;
    }

    @Override
    public void setWriteConcern(String write) {
        this.write = write;
    }

    public String getReadConcern() {
        return this.read;
    }

    @Override
    public void setReadConcern(String read) {
        this.read = read;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        if (owner == null) {
            throw new RuntimeException("The owner cannot be null");
        }
        this.owner = owner;
    }

    private void setAccessType(String accessType) {
        this.accessType = accessType.equals(AccessType.PUBLIC.toString()) ? AccessType.PUBLIC : AccessType.PRIVATE;
    }

    @Override
    public void setDbNames(String[] dbs) {
        this.dbNames = dbs;
    }

    protected String[] getDbNames() {
        return this.dbNames;
    }

    @Override
    public RemoteResourceBoolean exist() {
        return this.exist("MongoDB");
    }

    @Override
    public RemoteResourceBoolean exist(String backendType) {
        this.file = null;
        backendType = this.setBackendType(backendType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("exist");
        this.service = new OperationManager(this.primaryBackend, this.user, this.password, this.getCurrentOperation(), this.file, backendType, this.getDbNames());
        this.file = this.setOperationInfo(this.file, OperationDefinition.OPERATION.EXIST);
        return new RemoteResourceBoolean(this.file, this);
    }
}

