/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Upload
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Upload.class);
    protected InputStream is;
    private boolean replaceOption;
    protected String localPath;
    protected String remotePath;
    protected OutputStream os;
    protected MyFile resource;

    public Upload(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String bck, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, bck, dbs);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" UPLOAD " + myFile.getLocalPath() + " author: " + myFile.getOwner());
        }
        String objectId = null;
        try {
            objectId = this.put(this, myFile, this.isChunk(), false, this.replaceOption, false);
        }
        catch (Throwable e) {
            TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
            TransportManager tm = tmf.getTransport(this.backendType, myFile.getGcubeMemoryType(), this.dbNames, myFile.getWriteConcern(), myFile.getReadPreference());
            tm.close();
            this.logger.error("Problem in upload from: " + myFile.getLocalPath() + ": " + e.getMessage());
            throw new RemoteBackendException(" Error in upload operation ", e.getCause());
        }
        return objectId;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.replaceOption = replaceOption;
        this.setResource(file);
        if (remotePath.contains("/")) {
            String bucketName;
            this.bucket = bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
            return this.bucket;
        }
        this.bucket = remotePath;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String remotePath, String author, String[] server, String rootArea) {
        String bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        this.setResource(resource);
        this.is = resource.getInputStream();
        this.bucket = bucketName;
        return this.bucket;
    }

    public abstract String execute(MongoIOManager var1, MongoIOManager var2, MyFile var3, String var4, boolean var5) throws IOException;

    public InputStream getIs() {
        return this.is;
    }

    public void setIs(InputStream is) {
        this.is = is;
    }

    public boolean isReplaceOption() {
        return this.replaceOption;
    }

    public void setReplaceOption(boolean replaceOption) {
        this.replaceOption = replaceOption;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public OutputStream getOs() {
        return this.os;
    }

    public void setOs(OutputStream os) {
        this.os = os;
    }

    public MyFile getResource() {
        return this.resource;
    }

    public void setResource(MyFile resource) {
        this.resource = resource;
    }
}

