/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.gridfs.GridFSDBFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoOperationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadOperator
extends Download {
    final Logger logger = LoggerFactory.getLogger(DownloadOperator.class);

    public DownloadOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public ObjectId execute(MongoIOManager mongoPrimaryInstance, MongoIOManager mongoSecondaryInstance) throws IOException {
        OperationDefinition op = this.resource.getOperationDefinition();
        this.logger.info("Download operator execute method: " + op.toString() + " primary: " + mongoPrimaryInstance + "secondary " + mongoSecondaryInstance);
        mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), true);
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = this.resource.getOperation().getRemoteResource();
        this.logger.info("operation required by " + (Object)((Object)remoteResourceIdentifier));
        GridFSDBFile f = mongoPrimaryInstance.retrieveRemoteDescriptor(this.getBucket(), remoteResourceIdentifier, false);
        this.logger.info("DownloadOperator method: descriptor found: " + f);
        ObjectId id = null;
        if (f != null) {
            this.logger.debug("trying to retrieve the file associated to the descriptor " + f);
            id = mongoPrimaryInstance.getRemoteObject(this.resource, f);
        } else if (mongoSecondaryInstance != null) {
            this.logger.warn("trying to retrieve the descriptor in the secondary area" + f);
            GridFSDBFile secondaryF = mongoSecondaryInstance.retrieveRemoteDescriptor(this.getRemotePath(), remoteResourceIdentifier, true);
            if (secondaryF != null) {
                this.logger.warn("Descriptor found in the secondary area" + f);
                id = mongoSecondaryInstance.getRemoteObject(this.resource, secondaryF);
            }
        } else {
            mongoPrimaryInstance.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return id;
    }
}

