/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.composites.AbstractCellNameType;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.CompoundCType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;

public abstract class AbstractCompoundCellNameType
extends AbstractCellNameType {
    protected final CompoundCType clusteringType;
    protected final CompoundCType fullType;
    protected final int clusteringSize;
    protected final int fullSize;

    protected AbstractCompoundCellNameType(CompoundCType clusteringType, CompoundCType fullType) {
        super(AbstractCompoundCellNameType.isByteOrderComparable(fullType.types));
        this.clusteringType = clusteringType;
        this.fullType = fullType;
        this.clusteringSize = clusteringType.size();
        this.fullSize = fullType.size();
    }

    @Override
    public int clusteringPrefixSize() {
        return this.clusteringSize;
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public int size() {
        return this.fullSize;
    }

    @Override
    public AbstractType<?> subtype(int i) {
        return this.fullType.subtype(i);
    }

    @Override
    public CBuilder prefixBuilder() {
        return this.clusteringType.builder();
    }

    @Override
    public CBuilder builder() {
        return new CompoundCType.CompoundCBuilder(this);
    }

    @Override
    public Composite fromByteBuffer(ByteBuffer bytes) {
        if (!bytes.hasRemaining()) {
            return Composites.EMPTY;
        }
        ByteBuffer[] elements = new ByteBuffer[this.fullSize];
        int idx = bytes.position();
        int i = 0;
        int eoc = 0;
        boolean isStatic = false;
        if (CompositeType.isStaticName(bytes)) {
            isStatic = true;
            idx += 2;
        }
        while (idx < bytes.limit()) {
            AbstractCompoundCellNameType.checkRemaining(bytes, idx, 2);
            int length = bytes.getShort(idx) & 0xFFFF;
            AbstractCompoundCellNameType.checkRemaining(bytes, idx += 2, length + 1);
            elements[i++] = AbstractCompoundCellNameType.sliceBytes(bytes, idx, length);
            idx += length;
            eoc = bytes.get(idx++);
        }
        return this.makeWith(elements, i, Composite.EOC.from(eoc), isStatic);
    }

    @Override
    public AbstractType<?> asAbstractType() {
        return CompositeType.getInstance(this.fullType.types);
    }

    @Override
    public CellNameType.Deserializer newDeserializer(DataInput in) {
        return new CompositeDeserializer(this, in);
    }

    @Override
    protected CellName makeCellName(ByteBuffer[] components) {
        return (CellName)this.makeWith(components, components.length, Composite.EOC.NONE, false);
    }

    protected abstract Composite makeWith(ByteBuffer[] var1, int var2, Composite.EOC var3, boolean var4);

    protected abstract Composite copyAndMakeWith(ByteBuffer[] var1, int var2, Composite.EOC var3, boolean var4);

    private static class CompositeDeserializer
    implements CellNameType.Deserializer {
        private static byte[] EMPTY = new byte[0];
        private final AbstractCompoundCellNameType type;
        private final DataInput in;
        private byte[] nextFull;
        private int nextIdx;
        private final ByteBuffer[] nextComponents;
        private int nextSize;
        private Composite.EOC nextEOC;
        private boolean nextIsStatic;

        public CompositeDeserializer(AbstractCompoundCellNameType type, DataInput in) {
            this.type = type;
            this.in = in;
            this.nextComponents = new ByteBuffer[type.size()];
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.nextFull == null) {
                this.maybeReadNext();
            }
            return this.nextFull != EMPTY;
        }

        @Override
        public boolean hasUnprocessed() throws IOException {
            return this.nextFull != null;
        }

        @Override
        public int compareNextTo(Composite composite) throws IOException {
            this.maybeReadNext();
            if (composite.isEmpty()) {
                return this.nextFull == EMPTY ? 0 : 1;
            }
            if (this.nextFull == EMPTY) {
                return -1;
            }
            if (this.nextIsStatic != composite.isStatic()) {
                return this.nextIsStatic ? -1 : 1;
            }
            ByteBuffer previous = null;
            for (int i = 0; i < composite.size(); ++i) {
                ByteBuffer value2;
                ByteBuffer value1;
                if (!this.hasComponent(i)) {
                    return this.nextEOC == Composite.EOC.END ? 1 : -1;
                }
                AbstractType<?> comparator = this.type.subtype(i);
                int cmp = comparator.compareCollectionMembers(value1 = this.nextComponents[i], value2 = composite.get(i), previous);
                if (cmp != 0) {
                    return cmp;
                }
                previous = value1;
            }
            if (!this.allComponentsDeserialized() || composite.size() < this.nextSize) {
                return composite.eoc() == Composite.EOC.END ? -1 : 1;
            }
            if (this.nextEOC != composite.eoc()) {
                switch (this.nextEOC) {
                    case START: {
                        return -1;
                    }
                    case END: {
                        return 1;
                    }
                    case NONE: {
                        return composite.eoc() == Composite.EOC.START ? 1 : -1;
                    }
                }
            }
            return 0;
        }

        private boolean hasComponent(int i) {
            while (i >= this.nextSize && this.deserializeOne()) {
            }
            return i < this.nextSize;
        }

        private int readShort() {
            return (this.nextFull[this.nextIdx++] & 0xFF) << 8 | this.nextFull[this.nextIdx++] & 0xFF;
        }

        private int peekShort() {
            return (this.nextFull[this.nextIdx] & 0xFF) << 8 | this.nextFull[this.nextIdx + 1] & 0xFF;
        }

        private boolean deserializeOne() {
            if (this.allComponentsDeserialized()) {
                return false;
            }
            int length = this.readShort();
            ByteBuffer component = ByteBuffer.wrap(this.nextFull, this.nextIdx, length);
            this.nextIdx += length;
            this.nextComponents[this.nextSize++] = component;
            this.nextEOC = Composite.EOC.from(this.nextFull[this.nextIdx++]);
            return true;
        }

        private void deserializeAll() {
            while (this.deserializeOne()) {
            }
        }

        private boolean allComponentsDeserialized() {
            return this.nextIdx >= this.nextFull.length;
        }

        private void maybeReadNext() throws IOException {
            if (this.nextFull != null) {
                return;
            }
            this.nextIdx = 0;
            this.nextSize = 0;
            int length = this.in.readShort() & 0xFFFF;
            if (length == 0) {
                this.nextFull = EMPTY;
                return;
            }
            this.nextFull = new byte[length];
            this.in.readFully(this.nextFull);
            this.nextIsStatic = false;
            if (this.peekShort() == 65535) {
                this.nextIsStatic = true;
                this.readShort();
            }
        }

        @Override
        public Composite readNext() throws IOException {
            this.maybeReadNext();
            if (this.nextFull == EMPTY) {
                return Composites.EMPTY;
            }
            this.deserializeAll();
            Composite c = this.type.copyAndMakeWith(this.nextComponents, this.nextSize, this.nextEOC, this.nextIsStatic);
            this.nextFull = null;
            return c;
        }

        @Override
        public void skipNext() throws IOException {
            this.maybeReadNext();
            this.nextFull = null;
        }
    }
}

