/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.security.membershippolicy.RoleMembershipPolicyUtil;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.RoleServiceBaseImpl;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RoleServiceImpl
extends RoleServiceBaseImpl {
    public Role addRole(String className, long classPK, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type, String subtype, ServiceContext serviceContext) throws PortalException, SystemException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ROLE");
        User user = this.getUser();
        Role role = this.roleLocalService.addRole(user.getUserId(), className, classPK, name, titleMap, descriptionMap, type, subtype, serviceContext);
        if (type == 3) {
            OrganizationMembershipPolicyUtil.verifyPolicy((Role)role);
        } else if (type == 2) {
            SiteMembershipPolicyUtil.verifyPolicy((Role)role);
        } else {
            RoleMembershipPolicyUtil.verifyPolicy((Role)role);
        }
        return role;
    }

    public Role addRole(String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type) throws PortalException, SystemException {
        return this.addRole(null, 0L, name, titleMap, descriptionMap, type, null, null);
    }

    public void addUserRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        if (roleIds.length == 0) {
            return;
        }
        this.checkUserRolesPermission(userId, roleIds);
        RoleMembershipPolicyUtil.checkRoles((long[])new long[]{userId}, (long[])roleIds, null);
        this.roleLocalService.addUserRoles(userId, roleIds);
        RoleMembershipPolicyUtil.propagateRoles((long[])new long[]{userId}, (long[])roleIds, null);
    }

    public void deleteRole(long roleId) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"DELETE");
        this.roleLocalService.deleteRole(roleId);
    }

    public List<Role> getGroupRoles(long groupId) throws PortalException, SystemException {
        List roles = this.roleLocalService.getGroupRoles(groupId);
        return this.filterRoles(roles);
    }

    public Role getRole(long roleId) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"VIEW");
        return this.roleLocalService.getRole(roleId);
    }

    public Role getRole(long companyId, String name) throws PortalException, SystemException {
        Role role = this.roleLocalService.getRole(companyId, name);
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"VIEW");
        return role;
    }

    public List<Role> getUserGroupGroupRoles(long userId, long groupId) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List roles = this.roleLocalService.getUserGroupGroupRoles(userId, groupId);
        return this.filterRoles(roles);
    }

    public List<Role> getUserGroupRoles(long userId, long groupId) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List roles = this.roleLocalService.getUserGroupRoles(userId, groupId);
        return this.filterRoles(roles);
    }

    public List<Role> getUserRelatedRoles(long userId, List<Group> groups) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List roles = this.roleLocalService.getUserRelatedRoles(userId, groups);
        return this.filterRoles(roles);
    }

    public List<Role> getUserRoles(long userId) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List roles = this.roleLocalService.getUserRoles(userId);
        return this.filterRoles(roles);
    }

    public boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        return this.roleLocalService.hasUserRole(userId, companyId, name, inherited);
    }

    public boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        return this.roleLocalService.hasUserRoles(userId, companyId, names, inherited);
    }

    public void unsetUserRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        if (roleIds.length == 0) {
            return;
        }
        this.checkUserRolesPermission(userId, roleIds);
        RoleMembershipPolicyUtil.checkRoles((long[])new long[]{userId}, null, (long[])roleIds);
        this.roleLocalService.unsetUserRoles(userId, roleIds);
        RoleMembershipPolicyUtil.propagateRoles((long[])new long[]{userId}, null, (long[])roleIds);
    }

    public Role updateRole(long roleId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String subtype, ServiceContext serviceContext) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"UPDATE");
        Role oldRole = this.rolePersistence.findByPrimaryKey(roleId);
        ExpandoBridge oldExpandoBridge = oldRole.getExpandoBridge();
        Map oldExpandoAttributes = oldExpandoBridge.getAttributes();
        Role role = this.roleLocalService.updateRole(roleId, name, titleMap, descriptionMap, subtype, serviceContext);
        if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.verifyPolicy((Role)role, (Role)oldRole, (Map)oldExpandoAttributes);
        } else if (role.getType() == 2) {
            SiteMembershipPolicyUtil.verifyPolicy((Role)role, (Role)oldRole, (Map)oldExpandoAttributes);
        } else {
            RoleMembershipPolicyUtil.verifyPolicy((Role)role, (Role)oldRole, (Map)oldExpandoAttributes);
        }
        return role;
    }

    protected void checkUserRolesPermission(long userId, long[] roleIds) throws PortalException {
        int i2 = 0;
        while (i2 < roleIds.length) {
            RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleIds[i2], (String)"ASSIGN_MEMBERS");
            ++i2;
        }
    }

    protected List<Role> filterRoles(List<Role> roles) throws PortalException {
        ArrayList<Role> filteredRoles = new ArrayList<Role>();
        for (Role role : roles) {
            if (!RolePermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"VIEW")) continue;
            filteredRoles.add(role);
        }
        return filteredRoles;
    }
}

