/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.util.List;
import org.jamwiki.model.WikiReference;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.WikiLogger;

public class WikiReferenceTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiReferenceTag.class.getName());
    protected static final String REFERENCES_PARAM = "WikiReferenceTag.REFERENCES_PARAM";

    private WikiReference buildReference(ParserInput parserInput, String raw) {
        String name = this.buildReferenceName(raw);
        String content = JFlexParserUtil.tagContent(raw);
        List<WikiReference> references = JFlexParserUtil.retrieveReferences(parserInput);
        int count = 0;
        int citation = 1;
        for (WikiReference temp : references) {
            if (temp.getName() != null && name != null && name.equals(temp.getName())) {
                ++count;
                citation = temp.getCitation();
            }
            if (count != 0 || citation > temp.getCitation()) continue;
            citation = temp.getCitation() + 1;
        }
        WikiReference reference = new WikiReference(name, content, citation, count);
        return reference;
    }

    private String buildReferenceName(String raw) {
        return this.tagAttribute(raw, "name");
    }

    public String parse(JFlexLexer lexer, String raw, Object ... args) {
        if (logger.isTraceEnabled()) {
            logger.trace("reference: " + raw + " (" + lexer.yystate() + ")");
        }
        if (lexer.getMode() < 7) {
            return raw;
        }
        WikiReference reference = this.buildReference(lexer.getParserInput(), raw);
        this.processMetadata(lexer.getParserInput(), reference);
        StringBuilder html = new StringBuilder();
        html.append("<sup id=\"");
        html.append(reference.getReferenceName());
        html.append("\" class=\"reference\"><a href=\"#");
        html.append(reference.getNotationName());
        html.append("\">[" + reference.getCitation() + "]</a></sup>");
        return html.toString();
    }

    private void processMetadata(ParserInput parserInput, WikiReference reference) {
        List<WikiReference> references = JFlexParserUtil.retrieveReferences(parserInput);
        references.add(reference);
    }

    private String tagAttribute(String raw, String name) {
        int pos = raw.indexOf(62);
        if (pos == -1) {
            return null;
        }
        pos = raw.toLowerCase().indexOf(name.toLowerCase());
        if (pos == -1) {
            return null;
        }
        int start = raw.indexOf(34, pos);
        if (start == -1 || start + 1 >= raw.length()) {
            return null;
        }
        int end = raw.indexOf("\"", start + 1);
        if (end == -1 || end == start + 1) {
            return null;
        }
        return raw.substring(start + 1, end);
    }
}

