/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.util.Calendar;
import java.util.Date;
import jodd.datetime.DateTimeStamp;
import jodd.datetime.JDateTime;
import jodd.datetime.JulianDateStamp;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDateTimeConverter
implements TypeConverter<JDateTime> {
    @Override
    public JDateTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JDateTime) {
            return (JDateTime)value;
        }
        if (value instanceof Calendar) {
            return new JDateTime((Calendar)value);
        }
        if (value instanceof Date) {
            return new JDateTime((Date)value);
        }
        if (value instanceof Number) {
            return new JDateTime(((Number)value).longValue());
        }
        if (value instanceof JulianDateStamp) {
            return new JDateTime((JulianDateStamp)value);
        }
        if (value instanceof DateTimeStamp) {
            return new JDateTime((DateTimeStamp)value);
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            return new JDateTime(stringValue, "YYYY-MM-DD hh:mm:ss.mss");
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new JDateTime(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

