/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeUtils {
    static Type getActualTypeForFirstTypeVariable(Type type) {
        if (type instanceof Class) {
            return Object.class;
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.getActualTypeForFirstTypeVariable(((GenericArrayType)type).getGenericComponentType());
        }
        throw new IllegalArgumentException("Type '" + type + "' is not a Class, " + "ParameterizedType, or GenericArrayType. Can't extract class.");
    }

    static boolean isArray(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        return type instanceof GenericArrayType;
    }

    static Class<?> toRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType actualType = (ParameterizedType)type;
            return TypeUtils.toRawClass(actualType.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType actualType = (GenericArrayType)type;
            Class<?> rawClass = TypeUtils.toRawClass(actualType.getGenericComponentType());
            return TypeUtils.wrapWithArray(rawClass);
        }
        if (type instanceof WildcardType) {
            WildcardType castedType = (WildcardType)type;
            return TypeUtils.toRawClass(castedType.getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("Type '" + type + "' is not a Class, " + "ParameterizedType, or GenericArrayType. Can't extract class.");
    }

    static Class<?> wrapWithArray(Class<?> rawClass) {
        return Array.newInstance(rawClass, 0).getClass();
    }

    private TypeUtils() {
    }
}

