/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.cache.transactional.TransactionalPortalCacheHelper;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.hibernate.LastSessionRecorderUtil;
import com.liferay.portal.spring.transaction.BaseTransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionCommitCallbackUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class DefaultTransactionExecutor
extends BaseTransactionExecutor {
    private static Log _log = LogFactoryUtil.getLog(DefaultTransactionExecutor.class);

    @Override
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttribute transactionAttribute, MethodInvocation methodInvocation) throws Throwable {
        TransactionStatus transactionStatus = platformTransactionManager.getTransaction((TransactionDefinition)transactionAttribute);
        boolean newTransaction = transactionStatus.isNewTransaction();
        if (newTransaction) {
            TransactionalPortalCacheHelper.begin();
            TransactionCommitCallbackUtil.pushCallbackList();
        }
        Object returnValue = null;
        try {
            if (newTransaction) {
                LastSessionRecorderUtil.syncLastSessionState();
            }
            returnValue = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.processThrowable(platformTransactionManager, throwable, transactionAttribute, transactionStatus);
        }
        this.processCommit(platformTransactionManager, transactionStatus);
        return returnValue;
    }

    protected void processCommit(PlatformTransactionManager platformTransactionManager, TransactionStatus transactionStatus) {
        boolean hasError = false;
        try {
            try {
                platformTransactionManager.commit(transactionStatus);
            }
            catch (TransactionSystemException tse) {
                _log.error((Object)"Application exception overridden by commit exception", (Throwable)tse);
                hasError = true;
                throw tse;
            }
            catch (RuntimeException re) {
                _log.error((Object)"Application exception overridden by commit exception", (Throwable)re);
                hasError = true;
                throw re;
            }
            catch (Error e2) {
                _log.error((Object)"Application exception overridden by commit error", (Throwable)e2);
                hasError = true;
                throw e2;
            }
        }
        finally {
            if (transactionStatus.isNewTransaction()) {
                if (hasError) {
                    TransactionalPortalCacheHelper.rollback();
                    TransactionCommitCallbackUtil.popCallbackList();
                    EntityCacheUtil.clearLocalCache();
                    FinderCacheUtil.clearLocalCache();
                } else {
                    TransactionalPortalCacheHelper.commit();
                    this.invokeCallbacks();
                }
            }
        }
    }

    protected void processThrowable(PlatformTransactionManager platformTransactionManager, Throwable throwable, TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) throws Throwable {
        block9: {
            if (transactionAttribute.rollbackOn(throwable)) {
                try {
                    try {
                        platformTransactionManager.rollback(transactionStatus);
                        break block9;
                    }
                    catch (TransactionSystemException tse) {
                        _log.error((Object)"Application exception overridden by rollback exception", (Throwable)tse);
                        throw tse;
                    }
                    catch (RuntimeException re) {
                        _log.error((Object)"Application exception overridden by rollback exception", (Throwable)re);
                        throw re;
                    }
                    catch (Error e2) {
                        _log.error((Object)"Application exception overridden by rollback error", (Throwable)e2);
                        throw e2;
                    }
                }
                finally {
                    if (transactionStatus.isNewTransaction()) {
                        TransactionalPortalCacheHelper.rollback();
                        TransactionCommitCallbackUtil.popCallbackList();
                        EntityCacheUtil.clearLocalCache();
                        FinderCacheUtil.clearLocalCache();
                    }
                }
            }
            this.processCommit(platformTransactionManager, transactionStatus);
        }
        throw throwable;
    }
}

