/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.journal.DuplicateFeedIdException;
import com.liferay.portlet.journal.FeedContentFieldException;
import com.liferay.portlet.journal.FeedIdException;
import com.liferay.portlet.journal.FeedNameException;
import com.liferay.portlet.journal.FeedTargetLayoutFriendlyUrlException;
import com.liferay.portlet.journal.FeedTargetPortletIdException;
import com.liferay.portlet.journal.NoSuchFeedException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.JournalFeedServiceUtil;
import com.liferay.util.RSSUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFeedAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (Validator.isNull((String)cmd)) {
            return;
        }
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFeed(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFeeds(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFeedException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e2 instanceof DuplicateFeedIdException || e2 instanceof FeedContentFieldException || e2 instanceof FeedIdException || e2 instanceof FeedNameException || e2 instanceof FeedTargetLayoutFriendlyUrlException || e2 instanceof FeedTargetPortletIdException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getFeed((PortletRequest)renderRequest);
            }
        }
        catch (NoSuchFeedException noSuchFeedException) {
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.journal.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_feed"));
    }

    protected void deleteFeeds(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] deleteFeedIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteFeedIds"));
        int i2 = 0;
        while (i2 < deleteFeedIds.length) {
            JournalFeedServiceUtil.deleteFeed((long)groupId, (String)deleteFeedIds[i2]);
            ++i2;
        }
    }

    protected void updateFeed(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String feedId = ParamUtil.getString((PortletRequest)actionRequest, (String)"feedId");
        boolean autoFeedId = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoFeedId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        String structureId = ParamUtil.getString((PortletRequest)actionRequest, (String)"structureId");
        String templateId = ParamUtil.getString((PortletRequest)actionRequest, (String)"templateId");
        String rendererTemplateId = ParamUtil.getString((PortletRequest)actionRequest, (String)"rendererTemplateId");
        int delta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"delta");
        String orderByCol = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByCol");
        String orderByType = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByType");
        String targetLayoutFriendlyUrl = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetLayoutFriendlyUrl");
        String targetPortletId = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetPortletId");
        String contentField = ParamUtil.getString((PortletRequest)actionRequest, (String)"contentField");
        String feedType = ParamUtil.getString((PortletRequest)actionRequest, (String)"feedType", (String)RSSUtil.FEED_TYPE_DEFAULT);
        String feedFormat = RSSUtil.getFeedTypeFormat((String)feedType);
        double feedVersion = RSSUtil.getFeedTypeVersion((String)feedType);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalFeed.class.getName(), (PortletRequest)actionRequest);
        if (cmd.equals("add")) {
            JournalFeedServiceUtil.addFeed((long)groupId, (String)feedId, (boolean)autoFeedId, (String)name, (String)description, (String)type, (String)structureId, (String)templateId, (String)rendererTemplateId, (int)delta, (String)orderByCol, (String)orderByType, (String)targetLayoutFriendlyUrl, (String)targetPortletId, (String)contentField, (String)feedFormat, (double)feedVersion, (ServiceContext)serviceContext);
        } else {
            JournalFeedServiceUtil.updateFeed((long)groupId, (String)feedId, (String)name, (String)description, (String)type, (String)structureId, (String)templateId, (String)rendererTemplateId, (int)delta, (String)orderByCol, (String)orderByType, (String)targetLayoutFriendlyUrl, (String)targetPortletId, (String)contentField, (String)feedFormat, (double)feedVersion, (ServiceContext)serviceContext);
        }
    }
}

