/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.operation.UploadOperator;

public class UploadAndUnlock
extends Operation {
    public UploadAndUnlock(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" UPLOAD " + myFile.getLocalPath() + " author: " + myFile.getOwner());
        }
        UploadOperator upload = new UploadOperator(this.getServer(), this.getUser(), this.getPassword(), this.getBucket(), this.getMonitor(), this.isChunk(), this.getBackendType(), this.getDbNames());
        String objectId = null;
        try {
            objectId = this.put(upload, myFile, this.isChunk(), false, false, true);
        }
        catch (Exception e) {
            TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
            TransportManager tm = tmf.getTransport(transport, this.backendType, myFile.getGcubeMemoryType(), this.dbNames, myFile.getWriteConcern(), myFile.getReadPreference());
            tm.close();
            throw new RemoteBackendException(" Error in uploadAndUnlock operation ", e);
        }
        return objectId;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName;
        this.bucket = bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

