/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.walluck.net.ProxyConnection;
import org.walluck.oscar.AIMConnectionListener;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.KeepAliveTask;
import org.walluck.oscar.ListenerEntry;
import org.walluck.oscar.MsgCookie;
import org.walluck.oscar.RateClass;
import org.walluck.oscar.ReceiveQueueThread;
import org.walluck.oscar.RequestIDManagerTask;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.SNACHashMap;
import org.walluck.oscar.SNACPair;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.TransmitQueueThread;
import org.walluck.oscar.handlers.Listener;
import org.walluck.oscar.handlers.MiscListener;
import org.walluck.oscar.handlers.icq.ICQPacket;
import org.walluck.util.Queue;

public class AIMConnection
extends Thread {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$AIMConnection == null ? (class$org$walluck$oscar$AIMConnection = AIMConnection.class$("org.walluck.oscar.AIMConnection")) : class$org$walluck$oscar$AIMConnection).getName());
    private AIMSession sess;
    private Object internal;
    private long lastActivity;
    private long forcedLatency = 100L;
    private String host;
    private int port;
    private int type;
    private int subtype;
    private Socket socket;
    private URLConnection uc;
    private InputStream is;
    private OutputStream os;
    private volatile Thread thread = this;
    private TransmitQueueThread tqt = null;
    private ReceiveQueueThread rqt = null;
    private KeepAliveTask kat = null;
    private RequestIDManagerTask rimt = null;
    private Queue transmitQueue = new Queue();
    private Queue receiveQueue = new Queue();
    private Vector listenerEntries = new Vector(20);
    private SNACHashMap hash;
    private Hashtable ihash;
    private ArrayList groups = new ArrayList(10);
    private ArrayList rates = new ArrayList(5);
    private int retryTime = 10000;
    private ArrayList members = new ArrayList(480);
    private int retries = 0;
    private String dest;
    private static final short MAX_SEQ_NO = Short.MAX_VALUE;
    private short lastSeq = (short)-1;
    private static final int MAX_ID_NO = Integer.MAX_VALUE;
    private static final int SERVER_ID_BIT = Integer.MIN_VALUE;
    private int lastId = -1;
    private static final int MAX_PACKET_ID_NO = Short.MAX_VALUE;
    private int lastPacketId = -1;
    private static final int MAX_MSG_ID_NO = Short.MAX_VALUE;
    private short lastMsgId = (short)-1;
    private int flags;
    private ProxyConnection pc;
    private HashMap msgCookies = new HashMap();
    private static final Iterator NULL_ITERATOR = new Vector(0).iterator();
    static /* synthetic */ Class class$org$walluck$oscar$AIMConnection;

    public AIMConnection(AIMSession sess, int type, String dest, ProxyConnection pc) {
        this.sess = sess;
        this.type = type;
        this.dest = dest;
        this.lastActivity = System.currentTimeMillis();
        sess.addConn(this);
        this.hash = new SNACHashMap(sess, this, 16);
        if (sess.isICQ()) {
            this.ihash = new Hashtable();
        }
        this.pc = pc;
    }

    public AIMConnection(AIMSession sess, int type, String dest) {
        this.sess = sess;
        this.type = type;
        this.dest = dest;
        this.lastActivity = System.currentTimeMillis();
        sess.addConn(this);
        this.hash = new SNACHashMap(sess, this, 16);
        if (sess.isICQ()) {
            this.ihash = new Hashtable();
        }
    }

    public int nextSeq() {
        if (this.lastSeq == -1) {
            this.lastSeq = (short)Math.floor(Math.random() * 32767.0);
        }
        if (this.lastSeq >= Short.MAX_VALUE || this.lastSeq < 0) {
            this.lastSeq = 0;
        }
        short s = this.lastSeq;
        this.lastSeq = (short)(s + 1);
        return s;
    }

    public int nextId() {
        if (this.lastId == -1) {
            this.lastId = 0;
        }
        if (this.lastId >= Integer.MAX_VALUE || this.lastId < 0) {
            this.lastId = 0;
        }
        this.lastId &= Integer.MAX_VALUE;
        return this.lastId++;
    }

    public int nextPacketId() {
        if (this.lastPacketId == -1) {
            this.lastPacketId = 2;
        }
        if (this.lastPacketId >= Short.MAX_VALUE || this.lastPacketId < 0) {
            this.lastPacketId = 2;
        }
        return this.lastPacketId++;
    }

    public int nextMsgId() {
        if (this.lastMsgId == -1) {
            this.lastMsgId = Short.MAX_VALUE;
        }
        short s = this.lastMsgId;
        this.lastMsgId = (short)(s - 1);
        return s;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void connect() throws IOException {
        do {
            if (this.dest == null) continue;
            try {
                this.connect2(this.dest);
                this.retries = 0;
                Iterator i = this.sess.getListeners(252, 1);
                while (i.hasNext()) {
                    ((AIMConnectionListener)((Object)i)).connectionEstablished(this.sess, this);
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
                if (this.retries == 0) {
                    this.close();
                    throw new IOException("Connection to " + this.dest + " failed (" + ioe + ")");
                }
                try {
                    AIMConnection.sleep(this.retryTime);
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)"InterruptedException", (Throwable)ie);
                }
            }
        } while (--this.retries >= 0);
    }

    private void connect2(String dest) throws IOException {
        int loc = dest.indexOf(":");
        if (loc != -1 && loc + 1 != dest.length()) {
            this.host = dest.substring(0, loc);
            this.port = Integer.parseInt(dest.substring(loc + 1));
        } else {
            this.host = dest;
            this.port = 5190;
        }
        if (this.pc != null) {
            this.pc.connect(this.host, this.port);
            this.socket = this.pc.getSocket();
            this.uc = this.pc.getURLConnection();
        } else {
            this.socket = new Socket(this.host, this.port);
            this.socket.setTcpNoDelay(false);
        }
        if (this.socket != null) {
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
        } else if (this.uc != null) {
            this.is = this.uc.getInputStream();
            this.os = this.uc.getOutputStream();
        } else {
            throw new IOException();
        }
        LOG.debug((Object)("Connected to " + this.host + ":" + this.port));
        AIMInputStream inbuffer = new AIMInputStream(this.is);
        FLAP flap = inbuffer.readFLAP();
        int flapVersion = -1;
        if (flap.getLength() == 4 && (flapVersion = inbuffer.readInt()) != 1) {
            throw new IOException("Server sent unsupported FLAP version " + Integer.toHexString(flapVersion));
        }
        this.tqt = new TransmitQueueThread(this.sess, this);
        this.tqt.start();
        this.rqt = new ReceiveQueueThread(this.sess, this);
        this.rqt.start();
        if (this.type == 2) {
            this.kat = new KeepAliveTask(this);
            this.sess.getTimer().schedule((TimerTask)this.kat, 60000L, 60000L);
        }
        this.rimt = new RequestIDManagerTask(this);
        this.sess.getTimer().schedule((TimerTask)this.rimt, 100000L, 100000L);
        this.start();
    }

    public ArrayList getMembers() {
        return this.members;
    }

    public void addGroup(int version) {
        this.groups.add(new Integer(version));
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public void setGroups(ArrayList groups) {
        this.groups = groups;
    }

    public boolean supportsGroup(int group) {
        Iterator i = this.groups.iterator();
        while (i.hasNext()) {
            Integer j = (Integer)i.next();
            if (j != group) continue;
            return true;
        }
        return false;
    }

    public static synchronized AIMConnection findByGroup(AIMSession sess, int group) {
        Iterator i = sess.getConnList().iterator();
        while (i.hasNext()) {
            AIMConnection conn = (AIMConnection)i.next();
            Iterator i2 = conn.getGroups().iterator();
            while (i2.hasNext()) {
                Integer j = (Integer)i2.next();
                if (j != group) continue;
                return conn;
            }
        }
        return null;
    }

    public boolean isInSess(AIMSession sess) {
        Iterator i = sess.getConnList().iterator();
        while (i.hasNext()) {
            AIMConnection cur = (AIMConnection)i.next();
            if (cur != this) continue;
            return true;
        }
        return false;
    }

    private void closeReal() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
        this.sess.remConn(this);
        this.thread = null;
        this.tqt = null;
        this.rqt = null;
        if (this.kat != null) {
            this.kat.cancel();
        }
        if (this.rimt != null) {
            this.rimt.cancel();
        }
        if (this.transmitQueue != null) {
            this.transmitQueue.clear();
            this.transmitQueue = null;
        }
        if (this.receiveQueue != null) {
            this.receiveQueue.clear();
            this.receiveQueue = null;
        }
        if (this.rates != null) {
            this.rates.clear();
            this.rates = null;
        }
        if (this.groups != null) {
            this.groups.clear();
            this.groups = null;
        }
        if (this.members != null) {
            this.members.clear();
            this.members = null;
        }
        if (this.is != null) {
            this.is.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        if (this.uc != null) {
            this.uc = null;
        }
        LOG.debug((Object)("Closed connection to " + this.host + ":" + this.port));
    }

    public static void killAllInSess(AIMSession sess) {
        if (sess == null || sess.getConnList() == null) {
            return;
        }
        sess.getTimer().cancel();
        Enumeration e = sess.getConnList().elements();
        while (e.hasMoreElements()) {
            AIMConnection conn = (AIMConnection)e.nextElement();
            conn.close();
        }
    }

    public ArrayList getRates() {
        return this.rates;
    }

    public void addRate(RateClass rate) {
        this.rates.add(rate);
    }

    public RateClass findRate(int classID) {
        for (int i = 0; i < this.rates.size(); ++i) {
            RateClass rc = (RateClass)this.rates.get(i);
            if (rc.getClassID() != classID) continue;
            return rc;
        }
        return this.rates.size() == 0 ? null : (RateClass)this.rates.get(this.rates.size() - 1);
    }

    public RateClass findRate(int family, int subtype) {
        for (int i = 0; i < this.members.size(); ++i) {
            SNACPair sp = (SNACPair)this.members.get(i);
            if (sp.getFamily() != family || sp.getSubtype() != subtype) continue;
            return sp.getRateClass();
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static void connKill(AIMSession sess) {
        Iterator i = sess.getConnList().iterator();
        while (i.hasNext()) {
            AIMConnection conn = (AIMConnection)i.next();
            conn.close();
        }
    }

    public void sendSignoff(AIMConnection conn) throws IOException {
        conn.sendFrame(new AIMFrame(conn, 0, new FLAP(4), null, null));
    }

    public void close() {
        try {
            if (this.type == 2) {
                this.sendSignoff(this);
            }
            this.closeReal();
        }
        catch (SocketException se) {
            LOG.error((Object)"SocketException", (Throwable)se);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
    }

    public synchronized Queue getTransmitQueue() {
        return this.transmitQueue;
    }

    public synchronized Queue getReceiveQueue() {
        return this.receiveQueue;
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.thread == thisThread) {
            AIMInputStream buffer = new AIMInputStream(this.is);
            try {
                AIMFrame frame = new AIMFrame(this, 0, buffer);
                if (frame == null) continue;
                this.receiveQueue.push(frame);
            }
            catch (IOException ioe) {
                return;
            }
        }
    }

    public void sendFrame(AIMFrame frame) throws IOException {
        FLAP flap = frame.getFLAP();
        ICQPacket p = frame.getICQPacket();
        SNAC snac = frame.getSNAC();
        byte[] data = frame.getData();
        AIMOutputStream buffer = new AIMOutputStream();
        String debugMsg = "";
        if (flap != null && p == null) {
            flap.setSeqNum(this.nextSeq());
            debugMsg = "==> FLAP(" + Integer.toHexString(flap.getCommand()) + ", " + Integer.toHexString(flap.getChannel()) + ", " + Integer.toHexString(flap.getSeqNum()) + ", " + flap.getLength() + ")";
            buffer.writeFLAP(flap);
        }
        if (snac != null && p == null) {
            if (snac.getId() <= 0) {
                int sid = this.nextId();
                sid = (sid << 16) + snac.getSubtype();
                snac.setId(sid);
            }
            if (snac.wantResponse()) {
                LOG.debug((Object)("Want a response for SNAC (" + Integer.toHexString(snac.getFamily()) + "/" + Integer.toHexString(snac.getSubtype()) + ") ReqID=" + Integer.toHexString(snac.getId())));
                this.hash.put(snac);
            }
            debugMsg = debugMsg + " SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ", " + Integer.toHexString(snac.getFlags()) + ", " + Integer.toHexString(snac.getId()) + ")";
            buffer.writeSNAC(snac);
        }
        if (p != null) {
            AIMOutputStream buffer2 = new AIMOutputStream();
            buffer2.writeIntLE(Integer.parseInt(p.getSN()));
            buffer2.writeShortLE(p.getCmd());
            int pid = this.nextPacketId();
            p.setId(pid);
            buffer2.writeShortLE(p.getId());
            this.ihash.put(new Integer(pid), p);
            debugMsg = debugMsg + " ==> ICQPACKET(0x" + Integer.toHexString(p.getCmd()) + ", 0x" + Integer.toHexString(p.getId());
            int subcmd = p.getSubcmd();
            if (subcmd > 0) {
                buffer2.writeShortLE(subcmd);
                debugMsg = debugMsg + ", " + Integer.toHexString(subcmd);
            }
            debugMsg = debugMsg + ")";
            FLAP iflap = new FLAP(2);
            SNAC isnac = new SNAC(21, 2, 0, null, true);
            TLVChain tlvchain = new TLVChain(1);
            if (!p.isSMS()) {
                if (p.getData() != null) {
                    buffer2.writeBytes(p.getData());
                }
                byte[] b = buffer2.getBytes();
                AIMOutputStream tmpbuffer = new AIMOutputStream(b.length + 2);
                tmpbuffer.writeShortLE(b.length);
                tmpbuffer.writeBytes(b);
                tlvchain.addBytes(1, tmpbuffer.getBytes());
            } else {
                AIMOutputStream buffer3 = new AIMOutputStream();
                TLVChain tlvchain2 = new TLVChain(2);
                AIMOutputStream buffer4 = new AIMOutputStream(16);
                buffer4.writeInt(0);
                buffer4.writeInt(0);
                buffer4.writeInt(0);
                buffer4.writeInt(0);
                tlvchain2.addBytes(1, buffer4.getBytes());
                tlvchain2.addBytes(0, p.getData());
                buffer3.writeTLVChain(tlvchain2);
                tlvchain.addBytes(1, buffer3.getBytes());
            }
            iflap.setLength(tlvchain.length() + 10);
            iflap.setSeqNum(this.nextSeq());
            frame.setFLAP(iflap);
            buffer.writeFLAP(iflap);
            int sid = (pid - 1 << 16) + (short)isnac.getSubtype();
            isnac.setId(sid);
            frame.setSNAC(isnac);
            buffer.writeSNAC(isnac);
            buffer.writeTLVChain(tlvchain);
        }
        if (data != null) {
            debugMsg = debugMsg + " DATA(" + (snac != null ? data.length + 10 : data.length) + ")";
            buffer.writeBytes(data);
        } else {
            debugMsg = debugMsg + " DATA(0)";
        }
        if (snac != null) {
            LOG.debug((Object)(AIMUtil.snacToString(snac.getFamily(), 0) + "::" + AIMUtil.snacToString(snac.getFamily(), snac.getSubtype())));
        }
        LOG.debug((Object)debugMsg);
        byte[] b = buffer.getBytes();
        LOG.debug((Object)AIMUtil.hexdump(b));
        try {
            if (this.socket != null && this.os != null) {
                this.os.write(b);
            }
        }
        catch (SocketException se) {
            LOG.error((Object)"SocketException", (Throwable)se);
        }
        this.lastActivity = System.currentTimeMillis();
    }

    public synchronized void enqueueFrame(AIMFrame frame) {
        this.transmitQueue.push(frame);
    }

    public synchronized ListenerEntry lookupListenerEntry(int family, int subtype) {
        Iterator i = this.listenerEntries.iterator();
        while (i.hasNext()) {
            ListenerEntry le = (ListenerEntry)i.next();
            if (le.getFamily() != family || le.getSubtype() != subtype) continue;
            return le;
        }
        return null;
    }

    public synchronized ListenerEntry lookupListenerEntryCreate(int family, int subtype) {
        ListenerEntry le = this.lookupListenerEntry(family, subtype);
        if (le == null) {
            LOG.debug((Object)("Creating listener entry for " + Integer.toHexString(family) + "/" + Integer.toHexString(subtype) + ". This should only be called once for each " + "family/subtype pair."));
            le = new ListenerEntry(family, subtype);
            this.listenerEntries.add(le);
        }
        return le;
    }

    public synchronized void registerListener(int family, int subtype, Listener listener) {
        ListenerEntry le = this.lookupListenerEntryCreate(family, subtype);
        le.getListeners().add(listener);
    }

    public synchronized void deregisiterListener(int family, int subtype, Listener listener) {
        ListenerEntry le = this.lookupListenerEntry(family, subtype);
        le.getListeners().remove(listener);
    }

    public synchronized Iterator getListeners(int family, int subtype) {
        ListenerEntry le = this.lookupListenerEntry(family, subtype);
        if (le != null) {
            return ((ArrayList)le.getListeners().clone()).iterator();
        }
        return NULL_ITERATOR;
    }

    public synchronized SNAC peekSNAC(int id) {
        return this.hash.peek(id);
    }

    public synchronized SNAC remSNAC(int id) {
        return this.hash.remove(id);
    }

    public synchronized int cleanSNACs(int maxAge) {
        return this.hash.clean(maxAge);
    }

    public void logOff(AIMSession sess) {
        AIMConnection.killAllInSess(sess);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Object getInternal() {
        return this.internal;
    }

    public void setInternal(Object internal) {
        this.internal = internal;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void setLastActivity(long lastActivity) {
        this.lastActivity = lastActivity;
    }

    public long getForcedLatency() {
        return this.forcedLatency;
    }

    public void setForcedLatency(long forcedLatency) {
        this.forcedLatency = forcedLatency;
    }

    public int getSubtype() {
        return this.subtype;
    }

    public void setSubtype(int subtype) {
        this.subtype = subtype;
    }

    public void updateRate(int classID) {
        RateClass rc = this.findRate(classID);
        if (rc == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (rc.getLastSent() != -1L) {
            rc.setCurrent(rc.getCurrentNow(now));
        }
        rc.setLastSent(now);
    }

    public void updateRate(int family, int subtype) {
        RateClass rc = this.findRate(family, subtype);
        if (rc == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (rc.getLastSent() != -1L) {
            rc.setCurrent(rc.getCurrentNow(now));
        }
        rc.setLastSent(now);
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    public AIMSession getSess() {
        return this.sess;
    }

    public Hashtable getICQHashtable() {
        return this.ihash;
    }

    public synchronized HashMap getMsgCookies() {
        return this.msgCookies;
    }

    public synchronized void addCookie(MsgCookie cookie) {
        this.msgCookies.put(cookie.getCookie(), cookie);
    }

    public synchronized MsgCookie remCookie(MsgCookie cookie) {
        if (cookie == null || this.msgCookies == null || !this.msgCookies.containsKey(cookie.getCookie())) {
            return null;
        }
        return (MsgCookie)this.msgCookies.remove(cookie.getCookie());
    }

    public synchronized int cleanCookies(int maxAge) {
        int count = 0;
        Iterator i = this.msgCookies.keySet().iterator();
        while (i.hasNext()) {
            byte[] key = (byte[])i.next();
            MsgCookie cookie = (MsgCookie)this.msgCookies.get(key);
            if (System.currentTimeMillis() - cookie.getAddTime() < (long)maxAge) continue;
            Iterator i2 = this.getListeners(65535, 65533);
            while (i2.hasNext()) {
                ((MiscListener)i2.next()).icbmRemoveCookie(this.sess, cookie);
            }
            i.remove();
            this.msgCookies.remove(key);
            ++count;
        }
        return count;
    }

    public static AIMConnection findByType(AIMSession sess, int type) {
        Iterator i = sess.getConnList().iterator();
        while (i.hasNext()) {
            AIMConnection conn = (AIMConnection)i.next();
            if (conn.getType() != type) continue;
            return conn;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

