/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.walluck.oscar.AIMUtil;

public class TLV {
    private int type;
    private int length;
    private byte[] value;

    public TLV() {
    }

    public TLV(int type, int length, byte[] value) throws IOException {
        this.type = type;
        this.length = length;
        if (length < 0 || length > 8192) {
            throw new IOException("Invalid TLV length " + Integer.toHexString(length));
        }
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.length = value.length;
        this.value = value;
    }

    public String getValueString(String enc) throws UnsupportedEncodingException {
        return new String(this.value, AIMUtil.charsetAOLToJava(enc));
    }

    public String getValueString() throws UnsupportedEncodingException {
        return this.getValueString("us-ascii");
    }

    public void setValueString(String value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(value.length());
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeBytes(value);
        this.length = value.length();
        this.value = baos.toByteArray();
    }

    public byte getValueByte() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.value);
        DataInputStream dis = new DataInputStream(bais);
        return dis.readByte();
    }

    public void setValueByte(int value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(value);
        this.length = 1;
        this.value = baos.toByteArray();
    }

    public short getValueShort() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.value);
        DataInputStream dis = new DataInputStream(bais);
        return dis.readShort();
    }

    public void setValueShort(int value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(value);
        this.length = 2;
        this.value = baos.toByteArray();
    }

    public int getValueInt() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.value);
        DataInputStream dis = new DataInputStream(bais);
        return dis.readInt();
    }

    public void setValueInt(int value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(value);
        this.length = 4;
        this.value = baos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TLV(0x");
        sb.append(Integer.toHexString(this.type));
        sb.append(", ");
        sb.append(this.length);
        sb.append(", ");
        if (this.value == null) {
            sb.append("null");
        } else {
            sb.append(AIMUtil.byteArrayToHexString(this.value));
        }
        sb.append(")");
        return sb.toString();
    }
}

