/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.components;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.client.BuddyGroup;
import org.walluck.oscar.components.IMActions;
import org.walluck.oscar.components.IMWindow;
import org.walluck.oscar.components.Main;
import org.walluck.oscar.components.SessionManager;
import org.walluck.oscar.handlers.BuddyListListener;
import org.walluck.oscar.handlers.SSIHandler;

public class BuddyList
extends JTree
implements BuddyListListener,
MouseListener,
IMActions.IMActionsListener {
    private Object root = new Object();
    private EventListenerList listeners = new EventListenerList();
    private MyTreeModel model = new MyTreeModel();
    private JPopupMenu popup = new JPopupMenu("Action");
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;
    static /* synthetic */ Class class$org$walluck$oscar$components$BuddyList$MyTreeRenderer;

    public BuddyList() {
        int i;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setScrollsOnExpand(true);
        int rowCount = this.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            this.expandRow(i);
        }
        this.setModel(this.model);
        this.setCellRenderer(new MyTreeRenderer());
        this.addMouseListener(this);
        rowCount = this.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            this.expandRow(i);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        AIMConnection conn = AIMConnection.findByType(SessionManager.getSessions()[0], 2);
        conn.registerListener(3, 11, this);
        conn.registerListener(3, 12, this);
        IMActions.setIMActionsListener(this);
        this.imActionsChanged();
    }

    public void imActionsChanged() {
        Action act;
        MenuElement[] elms = this.popup.getSubElements();
        for (int i = 0; i < elms.length; ++i) {
            this.popup.remove(i);
        }
        Iterator iter = IMActions.getFirstActions();
        while (iter.hasNext()) {
            act = (Action)iter.next();
            this.popup.add(act);
        }
        iter = IMActions.getNormalActions();
        if (iter.hasNext()) {
            this.popup.addSeparator();
            do {
                act = (Action)iter.next();
                this.popup.add(act);
            } while (iter.hasNext());
        }
        if ((iter = IMActions.getLastActions()).hasNext()) {
            this.popup.addSeparator();
            do {
                act = (Action)iter.next();
                this.popup.add(act);
            } while (iter.hasNext());
        }
    }

    public void buddyChange(AIMSession sess, AIMFrame frame, UserInfo info) {
        System.out.println("[3] buddyChange called for " + info.getSN());
        SNAC snac = frame.getSNAC();
        if (snac.getFamily() == 3) {
            this.buddyChanged((Object)sess, info.getSN());
            if (snac.getSubtype() == 11) {
                System.out.println("Change icon to signon (open door)");
            } else if (snac.getSubtype() == 12) {
                System.out.println("Change icon to signoff (closed door)");
            }
        }
    }

    public void buddyChanged(Object from, BuddyGroup group) {
        if (from == null) {
            from = Main.OSCAR;
        }
        this.model.fireTreeChanged(new TreeModelEvent(from, new TreePath(this.root)));
    }

    public void buddyChanged(Object from, String sn) {
        if (from == null) {
            from = Main.OSCAR;
        }
        BuddyGroup g = Main.OSCAR.findBuddyGroupByBuddy(sn);
        this.model.fireTreeChanged(new TreeModelEvent(from, new Object[]{this.root, g}));
    }

    public void buddylistRights(AIMSession sess, AIMFrame frame, int maxbuddies, int maxwatchers) {
    }

    public Buddy getSelectedBuddy() {
        Object obj;
        TreePath path = this.getSelectionPath();
        Buddy b = null;
        if (path != null && (obj = path.getLastPathComponent()) instanceof Buddy) {
            b = (Buddy)obj;
        }
        return b;
    }

    public String getToolTipText(MouseEvent evt) {
        Buddy b;
        TreePath path;
        Object obj;
        int row = this.getRowForLocation(evt.getX(), evt.getY());
        String tooltip = null;
        if (row != -1 && (obj = (path = this.getPathForLocation(evt.getX(), evt.getY())).getLastPathComponent()) instanceof Buddy && !(b = (Buddy)obj).isTrue(Buddy.STATE, "Offline") && b.getProperty(Buddy.CAPABILITIES) != null && b.getProperty(Buddy.SIGNON_TIME) != null && b.getProperty(Buddy.IDLE_TIME) != null) {
            float warningLevel = ((Float)b.getProperty(Buddy.WARN_LEVEL)).floatValue();
            long idleTime = (Long)b.getProperty(Buddy.IDLE_TIME);
            String idleString = "";
            if (idleTime > 1L) {
                idleString = "&nbsp;" + Buddy.IDLE_TIME + ":&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + AIMUtil.prettyPrintTime(idleTime) + "<br>";
            }
            String spaces = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            String cap = Main.OSCAR.capsToText((Integer)b.getProperty(Buddy.CAPABILITIES));
            String capString = "";
            int index = 0;
            int look = 36;
            while (true) {
                if ((index = cap.indexOf(44, look)) == -1) break;
                capString = capString + cap.substring(0, index + 1);
                capString = capString + "<br>" + spaces;
                cap = cap.substring(index + 1, cap.length());
                look = 27;
            }
            capString = capString + cap.substring(0, cap.length());
            capString = Buddy.CAPABILITIES + ":&nbsp;" + capString;
            long signonTime = (Long)b.getProperty(Buddy.SIGNON_TIME);
            String stateString = "";
            if (b.getProperty(Buddy.STATE) != null && !b.isTrue(Buddy.STATE, "Online")) {
                stateString = "&nbsp;" + b.getProperty(Buddy.STATE) + "<br>";
            }
            String buddyComment = null;
            AIMSession sess = SessionManager.getSessions()[0];
            SSIHandler ssi = (SSIHandler)sess.getHandler(19);
            if (sess.getSSI().getLocal() != null) {
                try {
                    buddyComment = ssi.getBuddyComment(sess.getSSI().getLocal(), (String)b.getProperty(Buddy.GROUP), b.getName());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                if (buddyComment != null) {
                    buddyComment = "&nbsp;Comment:&nbsp;&nbsp;&nbsp;&nbsp;" + buddyComment;
                }
            }
            tooltip = "<html>&nbsp; " + b.getName() + "<br>" + "&nbsp;" + Buddy.CLASS + ":&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + b.getProperty(Buddy.CLASS) + "<br>" + "&nbsp;" + Buddy.WARN_LEVEL + ":&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + (int)((double)warningLevel + 0.5) + "%" + "<br>" + "&nbsp;" + Buddy.SIGNON_TIME + ":&nbsp;&nbsp;" + AIMUtil.prettyPrintTime(signonTime) + "<br>" + idleString + stateString + "&nbsp;" + capString;
            if (buddyComment != null) {
                tooltip = tooltip + "<br>" + buddyComment;
            }
            tooltip = tooltip + "</html>";
        }
        return tooltip;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        int selRow = this.getRowForLocation(evt.getX(), evt.getY());
        if (selRow != -1) {
            TreePath selPath = this.getPathForLocation(evt.getX(), evt.getY());
            this.setSelectionPath(selPath);
            Object obj = selPath.getLastPathComponent();
            if (obj instanceof Buddy) {
                IMActions.IMAction act;
                Buddy b = (Buddy)obj;
                Iterator iter = IMActions.getFirstActions();
                while (iter.hasNext()) {
                    act = (IMActions.IMAction)iter.next();
                    act.setEnabled(act.isActionEnabledForBuddy(b));
                }
                iter = IMActions.getNormalActions();
                while (iter.hasNext()) {
                    act = (IMActions.IMAction)iter.next();
                    act.setEnabled(act.isActionEnabledForBuddy(b));
                }
                iter = IMActions.getLastActions();
                while (iter.hasNext()) {
                    act = (IMActions.IMAction)iter.next();
                    act.setEnabled(act.isActionEnabledForBuddy(b));
                }
                if (evt.isPopupTrigger()) {
                    System.out.println("Showing popup");
                    this.popup.show(this, evt.getX(), evt.getY());
                } else if (evt.getClickCount() == 2 && b.isTrue(Buddy.STATE, "Online")) {
                    IMWindow.createIMWindow((AIMSession)b.getProperty(Buddy.SESSION), b);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyTreeRenderer
    extends DefaultTreeCellRenderer {
        private Icon awayIcon = new ImageIcon((class$org$walluck$oscar$components$BuddyList$MyTreeRenderer == null ? (class$org$walluck$oscar$components$BuddyList$MyTreeRenderer = BuddyList.class$("org.walluck.oscar.components.BuddyList$MyTreeRenderer")) : class$org$walluck$oscar$components$BuddyList$MyTreeRenderer).getResource("/img/buddy_away.png"));
        private Icon onlineIcon = new ImageIcon((class$org$walluck$oscar$components$BuddyList$MyTreeRenderer == null ? (class$org$walluck$oscar$components$BuddyList$MyTreeRenderer = BuddyList.class$("org.walluck.oscar.components.BuddyList$MyTreeRenderer")) : class$org$walluck$oscar$components$BuddyList$MyTreeRenderer).getResource("/img/buddy_online.png"));

        private MyTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof Buddy) {
                Buddy b = (Buddy)value;
                if (b.getProperty(Buddy.STATE) != null) {
                    label.setIcon(this.onlineIcon);
                }
                if (b.isTrue(Buddy.STATE, "Away")) {
                    label.setIcon(this.awayIcon);
                } else {
                    label.setIcon(null);
                }
                label.setText(b.getName());
                if (!b.isTrue(Buddy.IDLE_TIME, new Long(0L))) {
                    label.setEnabled(false);
                }
            } else if (value == BuddyList.this.root) {
                label.setText("Root");
            } else {
                label.setText(((BuddyGroup)value).getName());
            }
            return label;
        }
    }

    private class MyTreeModel
    implements TreeModel {
        private HashMap buddies = new HashMap();

        private MyTreeModel() {
        }

        public void addTreeModelListener(TreeModelListener l) {
            BuddyList.this.listeners.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = BuddyList.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
        }

        public void fireTreeChanged(TreeModelEvent evt) {
            EventListener[] l = BuddyList.this.listeners.getListeners(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = BuddyList.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener);
            for (int i = l.length - 1; i >= 0; --i) {
                ((TreeModelListener)l[i]).treeStructureChanged(evt);
            }
        }

        public Object getChild(Object parent, int index) {
            Object[] b = (Object[])this.buddies.get(parent);
            if (b == null) {
                b = this.refillTree(parent);
            }
            return b[index];
        }

        public int getChildCount(Object parent) {
            return this.refillTree(parent).length;
        }

        public int getIndexOfChild(Object parent, Object child) {
            int i;
            Object[] b = (Object[])this.buddies.get(parent);
            if (b != null) {
                int i2;
                for (i2 = 0; i2 < b.length && !b[i2].equals(child); ++i2) {
                }
                return i2 < b.length ? i2 : -1;
            }
            Object[] obj = this.refillTree(parent);
            for (i = 0; i < obj.length && !((BuddyGroup)obj[i]).getName().equals(((BuddyGroup)child).getName()); ++i) {
            }
            return i < obj.length ? i : -1;
        }

        public Object getRoot() {
            return BuddyList.this.root;
        }

        public boolean isLeaf(Object node) {
            return node != BuddyList.this.root && node instanceof Buddy;
        }

        private Object[] refillTree(Object parent) {
            this.buddies.clear();
            if (parent == BuddyList.this.root) {
                ArrayList groups;
                while ((groups = Main.OSCAR.getBuddyGroups()) == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Object[] g = new BuddyGroup[groups.size()];
                groups.toArray(g);
                this.buddies.put(BuddyList.this.root, g);
                return g;
            }
            BuddyGroup g = (BuddyGroup)parent;
            Object[] b = new Buddy[g.size()];
            g.toArray(b);
            this.buddies.put(parent, b);
            return b;
        }

        public void removeTreeModelListener(TreeModelListener l) {
            BuddyList.this.listeners.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = BuddyList.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }
}

