/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import jodd.introspector.Getter;
import jodd.introspector.PropertyDescriptor;
import jodd.json.JsonContext;
import jodd.json.JsonException;
import jodd.json.TypeJsonVisitor;

public class BeanSerializer
extends TypeJsonVisitor {
    protected final Object source;

    public BeanSerializer(JsonContext jsonContext, Object bean) {
        super(jsonContext, bean.getClass());
        this.source = bean;
    }

    public void serialize() {
        this.visit();
    }

    protected final void onSerializableProperty(String propertyName, PropertyDescriptor propertyDescriptor) {
        Object value;
        if (propertyDescriptor == null) {
            value = this.source.getClass().getName();
        } else {
            value = this.readProperty(this.source, propertyDescriptor);
            propertyName = this.typeData.resolveJsonName(propertyName);
        }
        this.onSerializableProperty(propertyName, propertyDescriptor == null ? null : propertyDescriptor.getType(), value);
    }

    protected void onSerializableProperty(String propertyName, Class propertyType, Object value) {
        this.jsonContext.pushName(propertyName, this.count > 0);
        this.jsonContext.serialize(value);
        if (this.jsonContext.isNamePopped()) {
            ++this.count;
        }
    }

    private Object readProperty(Object source, PropertyDescriptor propertyDescriptor) {
        Getter getter = propertyDescriptor.getGetter(this.declared);
        if (getter != null) {
            try {
                return getter.invokeGetter(source);
            }
            catch (Exception ex) {
                throw new JsonException(ex);
            }
        }
        return null;
    }
}

