/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.model;

import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.sync.model.SyncDLObject;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

@JSON
public class SyncDLObjectUpdate {
    private long _lastAccessTime;
    private int _resultsTotal;
    private List<SyncDLObject> _syncDLObjects;

    public SyncDLObjectUpdate(List<SyncDLObject> syncDLObjects, int resultsTotal, long lastAccessTime) {
        this._syncDLObjects = syncDLObjects;
        this._resultsTotal = resultsTotal;
        this._lastAccessTime = lastAccessTime;
    }

    public long getLastAccessTime() {
        return this._lastAccessTime;
    }

    public int getResultsTotal() {
        return this._resultsTotal;
    }

    @JSON
    public List<SyncDLObject> getSyncDLObjects() {
        return this._syncDLObjects;
    }

    public String toString() {
        StringBundler sb = new StringBundler(this._syncDLObjects.size() * 78 + 5);
        sb.append("{\"lastAccessTime\":");
        sb.append(this._lastAccessTime);
        sb.append(",\"resultsTotal\":");
        sb.append(this._resultsTotal);
        sb.append(",\"syncDLObjects\":[");
        int i = 0;
        while (i < this._syncDLObjects.size()) {
            SyncDLObject syncDLObject = this._syncDLObjects.get(i);
            sb.append("{\"changeLog\":");
            this.append(sb, syncDLObject.getChangeLog(), true);
            sb.append(",\"checksum\":");
            this.append(sb, syncDLObject.getChecksum(), false);
            sb.append(",\"companyId\":");
            sb.append(syncDLObject.getCompanyId());
            sb.append(",\"createTime\":");
            sb.append(syncDLObject.getCreateTime());
            sb.append(",\"description\":");
            this.append(sb, syncDLObject.getDescription(), true);
            sb.append(",\"event\":");
            this.append(sb, syncDLObject.getEvent(), false);
            sb.append(",\"extension\":");
            this.append(sb, syncDLObject.getExtension(), true);
            sb.append(",\"extraSettings\":");
            this.append(sb, syncDLObject.getExtraSettings(), true);
            sb.append(",\"lockExpirationDate\":");
            Date lockExpirationDate = syncDLObject.getLockExpirationDate();
            if (lockExpirationDate != null) {
                sb.append(lockExpirationDate.getTime());
            } else {
                sb.append("null");
            }
            sb.append(",\"lockUserId\":");
            sb.append(syncDLObject.getLockUserId());
            sb.append(",\"lockUserName\":");
            this.append(sb, syncDLObject.getLockUserName(), true);
            sb.append(",\"mimeType\":");
            this.append(sb, syncDLObject.getMimeType(), true);
            sb.append(",\"modifiedTime\":");
            sb.append(syncDLObject.getModifiedTime());
            sb.append(",\"name\":");
            this.append(sb, syncDLObject.getName(), true);
            sb.append(",\"parentFolderId\":");
            sb.append(syncDLObject.getParentFolderId());
            sb.append(",\"repositoryId\":");
            sb.append(syncDLObject.getRepositoryId());
            sb.append(",\"size\":");
            sb.append(syncDLObject.getSize());
            sb.append(",\"syncDLObjectId\":");
            sb.append(syncDLObject.getSyncDLObjectId());
            sb.append(",\"type\":");
            this.append(sb, syncDLObject.getType(), false);
            sb.append(",\"typePK\":");
            sb.append(syncDLObject.getTypePK());
            sb.append(",\"typeUuid\":");
            this.append(sb, syncDLObject.getTypeUuid(), false);
            sb.append(",\"userId\":");
            sb.append(syncDLObject.getUserId());
            sb.append(",\"userName\":");
            this.append(sb, syncDLObject.getUserName(), true);
            sb.append(",\"version\":");
            this.append(sb, syncDLObject.getVersion(), false);
            sb.append(",\"versionId\":");
            sb.append(syncDLObject.getVersionId());
            sb.append("}");
            if (i != this._syncDLObjects.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]}");
        return sb.toString();
    }

    protected void append(StringBundler sb, String s, boolean escape) {
        sb.append("\"");
        if (escape) {
            s = StringEscapeUtils.escapeJava((String)s);
        }
        sb.append(s);
        sb.append("\"");
    }
}

