/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.mail.model.Filter;
import com.liferay.mail.util.Hook;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.Future;

public class SendmailHook
implements Hook {
    private static Log _log = LogFactoryUtil.getLog(SendmailHook.class);

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        try {
            if (emailAddresses != null) {
                String home = PropsUtil.get("mail.hook.sendmail.home");
                File file = new File(String.valueOf(home) + "/" + userId + "/.forward");
                if (emailAddresses.size() > 0) {
                    StringBundler sb = new StringBundler(emailAddresses.size() * 2);
                    int i2 = 0;
                    while (i2 < emailAddresses.size()) {
                        String emailAddress = emailAddresses.get(i2);
                        sb.append(emailAddress);
                        sb.append("\n");
                        ++i2;
                    }
                    FileUtil.write((File)file, (String)sb.toString());
                } else {
                    file.delete();
                }
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        String addUserCmd = PropsUtil.get("mail.hook.sendmail.add.user");
        addUserCmd = StringUtil.replace((String)addUserCmd, (String)"%1%", (String)String.valueOf(userId));
        try {
            Future future = ProcessUtil.execute((OutputProcessor)ProcessUtil.LOGGING_OUTPUT_PROCESSOR, (String[])new String[]{addUserCmd});
            future.get();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        this.updatePassword(companyId, userId, password);
        this.updateEmailAddress(companyId, userId, emailAddress);
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
    }

    public void deleteEmailAddress(long companyId, long userId) {
        this.updateEmailAddress(companyId, userId, "");
    }

    public void deleteUser(long companyId, long userId) {
        this.deleteEmailAddress(companyId, userId);
        String deleteUserCmd = PropsUtil.get("mail.hook.sendmail.delete.user");
        deleteUserCmd = StringUtil.replace((String)deleteUserCmd, (String)"%1%", (String)String.valueOf(userId));
        try {
            Future future = ProcessUtil.execute((OutputProcessor)ProcessUtil.LOGGING_OUTPUT_PROCESSOR, (String[])new String[]{deleteUserCmd});
            future.get();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        String home = PropsUtil.get("mail.hook.sendmail.home");
        File file = new File(String.valueOf(home) + "/" + userId + "/.procmailrc");
        if (blocked == null || blocked.size() == 0) {
            file.delete();
            return;
        }
        StringBundler sb = new StringBundler(blocked.size() * 9 + 3);
        sb.append("ORGMAIL /var/spool/mail/$LOGNAME\n");
        sb.append("MAILDIR $HOME/\n");
        sb.append("SENDMAIL /usr/smin/sendmail\n");
        int i2 = 0;
        while (i2 < blocked.size()) {
            String emailAddress = blocked.get(i2);
            sb.append("\n");
            sb.append(":0\n");
            sb.append("* ^From.*");
            sb.append(emailAddress);
            sb.append("\n");
            sb.append("{\n");
            sb.append(":0\n");
            sb.append("/dev/null\n");
            sb.append("}\n");
            ++i2;
        }
        try {
            FileUtil.write((File)file, (String)sb.toString());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        try {
            String virtusertable = PropsUtil.get("mail.hook.sendmail.virtusertable");
            FileReader fileReader = new FileReader(virtusertable);
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)fileReader);
            StringBundler sb = new StringBundler();
            String s = unsyncBufferedReader.readLine();
            while (s != null) {
                if (!s.endsWith(" " + userId)) {
                    sb.append(s);
                    sb.append('\n');
                }
                s = unsyncBufferedReader.readLine();
            }
            if (emailAddress != null && !emailAddress.equals("")) {
                sb.append(emailAddress);
                sb.append(" ");
                sb.append(userId);
                sb.append('\n');
            }
            unsyncBufferedReader.close();
            fileReader.close();
            FileUtil.write((String)virtusertable, (String)sb.toString());
            String virtusertableRefreshCmd = PropsUtil.get("mail.hook.sendmail.virtusertable.refresh");
            Future future = ProcessUtil.execute((OutputProcessor)ProcessUtil.LOGGING_OUTPUT_PROCESSOR, (String[])new String[]{virtusertableRefreshCmd});
            future.get();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updatePassword(long companyId, long userId, String password) {
        String changePasswordCmd = PropsUtil.get("mail.hook.sendmail.change.password");
        changePasswordCmd = StringUtil.replace((String)changePasswordCmd, (String)"%1%", (String)String.valueOf(userId));
        changePasswordCmd = StringUtil.replace((String)changePasswordCmd, (String)"%2%", (String)password);
        try {
            Future future = ProcessUtil.execute((OutputProcessor)ProcessUtil.LOGGING_OUTPUT_PROCESSOR, (String[])new String[]{changePasswordCmd});
            future.get();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

