/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class IngresDB
extends BaseDB {
    private static final String[] _INGRES = new String[]{"--", "1", "0", "'1970-01-01'", "date('now')", " blob", " blob", " tinyint", " timestamp", " float", " integer", " bigint", " varchar(1000)", " long varchar", " varchar", "", "commit;\\g"};
    private static final boolean _SUPPORTS_ALTER_COLUMN_NAME = false;
    private static Log _log = LogFactoryUtil.getLog(IngresDB.class);
    private static IngresDB _instance = new IngresDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\n", (String)"'+x'0a'+'");
        return template;
    }

    @Override
    public boolean isSupportsAlterColumnName() {
        return false;
    }

    protected IngresDB() {
        super("ingres");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) {
        return null;
    }

    @Override
    protected String getServerName() {
        return "ingres";
    }

    @Override
    protected String[] getTemplate() {
        return _INGRES;
    }

    @Override
    protected String replaceTemplate(String template, String[] actual) {
        if (template == null || TEMPLATE == null || actual == null) {
            return null;
        }
        if (TEMPLATE.length != actual.length) {
            return template;
        }
        int i2 = 0;
        while (i2 < TEMPLATE.length) {
            template = TEMPLATE[i2].equals("##") || TEMPLATE[i2].equals("'01/01/1970'") ? template.replaceAll(TEMPLATE[i2], actual[i2]) : (TEMPLATE[i2].equals("COMMIT_TRANSACTION") ? StringUtil.replace((String)template, (String)(String.valueOf(TEMPLATE[i2]) + ";"), (String)actual[i2]) : template.replaceAll("\\b" + TEMPLATE[i2] + "\\b", actual[i2]));
            ++i2;
        }
        return template;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] tokens;
            String[] template;
            if (line.startsWith("alter_column_name ")) {
                line = "-- " + line;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("This statement is not supported by Ingres: " + line));
                }
            } else if (line.startsWith("alter_column_type ")) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_table_name ")) {
                template = this.buildTableNameTokens(line);
                line = StringUtil.replace((String)"alter table @old-table@ rename to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
            } else if (line.contains("drop index")) {
                tokens = StringUtil.split((String)line, (char)' ');
                line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
            } else if (line.contains("drop primary key")) {
                tokens = StringUtil.split((String)line, (char)' ');
                line = StringUtil.replace((String)"alter table @table@ drop constraint @table@_pkey;", (String)"@table@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

