/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.PortletAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.DefaultFriendlyURLMapper;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.bridges.wai.WAIPortlet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class WAIAutoDeployer
extends PortletAutoDeployer {
    private static final String[] _INIT_PARAM_DEFAULT_VALUES = new String[]{"500"};
    private static final String[] _INIT_PARAM_NAMES = new String[]{"wai.connector.iframe.height.default"};

    public WAIAutoDeployer() throws AutoDeployException {
        try {
            this.addRequiredJar(this.jars, "portals-bridges.jar");
        }
        catch (Exception e2) {
            throw new AutoDeployException((Throwable)e2);
        }
    }

    @Override
    public void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        super.copyXmls(srcFile, displayName, pluginPackage);
        FileUtil.delete((String)(srcFile + "/META-INF/context.xml"));
        String portletName = displayName;
        if (pluginPackage != null) {
            portletName = pluginPackage.getName();
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("portlet_name", displayName);
        filterMap.put("portlet_title", portletName);
        if (pluginPackage != null) {
            Properties deploymentSettings = pluginPackage.getDeploymentSettings();
            filterMap.put("portlet_class", deploymentSettings.getProperty("wai.portlet", WAIPortlet.class.getName()));
            filterMap.put("friendly_url_mapper_class", deploymentSettings.getProperty("wai.friendly.url.mapper", DefaultFriendlyURLMapper.class.getName()));
            filterMap.put("friendly_url_mapping", deploymentSettings.getProperty("wai.friendly.url.mapping", "waiapp"));
            filterMap.put("friendly_url_routes", deploymentSettings.getProperty("wai.friendly.url.routes", "com/liferay/util/bridges/wai/wai-friendly-url-routes.xml"));
        } else {
            filterMap.put("portlet_class", WAIPortlet.class.getName());
            filterMap.put("friendly_url_mapper_class", DefaultFriendlyURLMapper.class.getName());
            filterMap.put("friendly_url_mapping", "waiapp");
            filterMap.put("friendly_url_routes", "com/liferay/util/bridges/wai/wai-friendly-url-routes.xml");
        }
        this._setInitParams(filterMap, pluginPackage);
        this.copyDependencyXml("liferay-display.xml", srcFile + "/WEB-INF", filterMap);
        this.copyDependencyXml("liferay-portlet.xml", srcFile + "/WEB-INF", filterMap);
        this.copyDependencyXml("portlet.xml", srcFile + "/WEB-INF", filterMap);
        this.copyDependencyXml("iframe.jsp", srcFile + "/WEB-INF/jsp/liferay/wai");
    }

    private void _setInitParams(Map<String, String> filterMap, PluginPackage pluginPackage) {
        int i2 = 0;
        while (i2 < _INIT_PARAM_NAMES.length) {
            String name = _INIT_PARAM_NAMES[i2];
            String value = null;
            if (pluginPackage != null) {
                Properties deploymentSettings = pluginPackage.getDeploymentSettings();
                value = deploymentSettings.getProperty(name);
            }
            if (Validator.isNull(value)) {
                value = _INIT_PARAM_DEFAULT_VALUES[i2];
            }
            filterMap.put("init_param_name_" + i2, name);
            filterMap.put("init_param_value_" + i2, value);
            ++i2;
        }
    }
}

