/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.impl.BaseCommandReceiver;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PageCommandReceiver
extends BaseCommandReceiver {
    @Override
    protected String createFolder(CommandArgument commandArgument) {
        return "0";
    }

    @Override
    protected String fileUpload(CommandArgument commandArgument, String fileName, InputStream inputStream, String extension, long size) {
        return "0";
    }

    @Override
    protected void getFolders(CommandArgument commandArgument, Document document, Node rootNode) {
        try {
            this._getFolders(commandArgument, document, rootNode);
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
    }

    @Override
    protected void getFoldersAndFiles(CommandArgument commandArgument, Document document, Node rootNode) {
        try {
            this._getFolders(commandArgument, document, rootNode);
            this._getFiles(commandArgument, document, rootNode);
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
    }

    private void _getFiles(CommandArgument commandArgument, Document document, Node rootNode) throws Exception {
        if (commandArgument.getCurrentFolder().equals("/")) {
            return;
        }
        Element filesElement = document.createElement("Files");
        rootNode.appendChild(filesElement);
        Group group = commandArgument.getCurrentGroup();
        ArrayList layouts = new ArrayList();
        layouts.addAll(LayoutServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L));
        layouts.addAll(LayoutServiceUtil.getLayouts((long)group.getGroupId(), (boolean)true, (long)0L));
        if (("/" + commandArgument.getCurrentGroupName() + "/").equals(commandArgument.getCurrentFolder())) {
            for (Layout layout : layouts) {
                Element fileElement = document.createElement("File");
                filesElement.appendChild(fileElement);
                fileElement.setAttribute("name", this._getLayoutName(layout));
                fileElement.setAttribute("desc", this._getLayoutName(layout));
                fileElement.setAttribute("size", "");
                fileElement.setAttribute("url", this._getRelativeURL(layout, commandArgument.getThemeDisplay()));
            }
        } else {
            String layoutName = this._getLayoutName(commandArgument.getCurrentFolder());
            Layout layout = this._getLayout(group.getGroupId(), layoutName);
            if (layout == null) {
                return;
            }
            List layoutChildren = layout.getChildren();
            int i2 = 0;
            while (i2 < layoutChildren.size()) {
                layout = (Layout)layoutChildren.get(i2);
                Element fileElement = document.createElement("File");
                filesElement.appendChild(fileElement);
                fileElement.setAttribute("name", this._getLayoutName(layout));
                fileElement.setAttribute("desc", this._getLayoutName(layout));
                fileElement.setAttribute("size", this.getSize());
                fileElement.setAttribute("url", this._getRelativeURL(layout, commandArgument.getThemeDisplay()));
                ++i2;
            }
        }
    }

    private void _getFolders(CommandArgument commandArgument, Document document, Node rootNode) throws Exception {
        block3: {
            Group group;
            Element foldersElement;
            block4: {
                block2: {
                    foldersElement = document.createElement("Folders");
                    rootNode.appendChild(foldersElement);
                    if (!commandArgument.getCurrentFolder().equals("/")) break block2;
                    this.getRootFolders(commandArgument, document, foldersElement);
                    break block3;
                }
                group = commandArgument.getCurrentGroup();
                ArrayList layouts = new ArrayList();
                layouts.addAll(LayoutServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L));
                layouts.addAll(LayoutServiceUtil.getLayouts((long)group.getGroupId(), (boolean)true, (long)0L));
                if (!("/" + commandArgument.getCurrentGroupName() + "/").equals(commandArgument.getCurrentFolder())) break block4;
                for (Layout layout : layouts) {
                    Element folderElement = document.createElement("Folder");
                    foldersElement.appendChild(folderElement);
                    folderElement.setAttribute("name", "~" + this._getLayoutName(layout).replace('/', '>'));
                }
                break block3;
            }
            String layoutName = this._getLayoutName(commandArgument.getCurrentFolder());
            Layout layout = this._getLayout(group.getGroupId(), layoutName);
            if (layout == null) break block3;
            List layoutChildren = layout.getChildren();
            int i2 = 0;
            while (i2 < layoutChildren.size()) {
                layout = (Layout)layoutChildren.get(i2);
                Element folderElement = document.createElement("Folder");
                foldersElement.appendChild(folderElement);
                folderElement.setAttribute("name", "~" + this._getLayoutName(layout).replace('/', '>'));
                ++i2;
            }
        }
    }

    private Layout _getLayout(long groupId, String layoutName) throws Exception {
        Layout layout = null;
        try {
            layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)false, (String)layoutName);
            return layout;
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            try {
                layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)true, (String)layoutName);
                return layout;
            }
            catch (NoSuchLayoutException noSuchLayoutException2) {
                return null;
            }
        }
    }

    private String _getLayoutName(Layout layout) {
        return layout.getFriendlyURL();
    }

    private String _getLayoutName(String folderName) {
        String layoutName = folderName.substring(folderName.lastIndexOf(126) + 1, folderName.length() - 1);
        layoutName = layoutName.replace('>', '/');
        return layoutName;
    }

    private String _getRelativeURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String portalURL;
        String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)themeDisplay, (boolean)false);
        String canonicalURL = PortalUtil.getCanonicalURL((String)layoutFullURL, (ThemeDisplay)themeDisplay, (Layout)layout, (boolean)true);
        if (canonicalURL.startsWith(portalURL = themeDisplay.getPortalURL())) {
            return canonicalURL.substring(portalURL.length());
        }
        return canonicalURL;
    }
}

