/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.metadata;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.DummyWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.metadata.XMPDM;
import com.liferay.portal.metadata.XugglerRawMetadataProcessor;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.concurrent.Future;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;

public class TikaRawMetadataProcessor
extends XugglerRawMetadataProcessor {
    private static Log _log = LogFactoryUtil.getLog(TikaRawMetadataProcessor.class);
    private Parser _parser;

    public void setParser(Parser parser) {
        this._parser = parser;
    }

    protected static Metadata extractMetadata(InputStream inputStream, Metadata metadata, Parser parser) throws IOException {
        if (metadata == null) {
            metadata = new Metadata();
        }
        ParseContext parserContext = new ParseContext();
        parserContext.set(Parser.class, (Object)parser);
        WriteOutContentHandler contentHandler = new WriteOutContentHandler((Writer)new DummyWriter());
        try {
            parser.parse(inputStream, (ContentHandler)contentHandler, metadata, parserContext);
        }
        catch (Exception e2) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)e2);
            if (throwable instanceof CryptographyException || throwable instanceof EncryptedDocumentException || throwable instanceof UnsupportedZipFeatureException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to extract metadata from an encrypted file");
                }
            } else if (e2 instanceof TikaException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to extract metadata");
                }
            } else {
                _log.error((Object)e2, (Throwable)e2);
            }
            throw new IOException(e2.getMessage());
        }
        metadata.remove(XMPDM.ABS_PEAK_AUDIO_FILE_PATH.getName());
        metadata.remove(XMPDM.RELATIVE_PEAK_AUDIO_FILE_PATH.getName());
        return metadata;
    }

    @Override
    protected Metadata extractMetadata(String extension, String mimeType, File file) throws SystemException {
        Metadata metadata;
        Metadata metadata2 = super.extractMetadata(extension, mimeType, file);
        boolean forkProcess = false;
        if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains((Object[])PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, (Object)mimeType)) {
            forkProcess = true;
        }
        if (forkProcess) {
            ExtractMetadataProcessCallable extractMetadataProcessCallable = new ExtractMetadataProcessCallable(file, metadata2, this._parser);
            try {
                Future future = ProcessExecutor.execute((String)ClassPathUtil.getPortalClassPath(), (ProcessCallable)extractMetadataProcessCallable);
                return (Metadata)future.get();
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            metadata = TikaRawMetadataProcessor.extractMetadata(inputStream, metadata2, this._parser);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException((Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                throw throwable;
            }
        }
        StreamUtil.cleanUp((InputStream)inputStream);
        return metadata;
    }

    @Override
    protected Metadata extractMetadata(String extension, String mimeType, InputStream inputStream) throws SystemException {
        Metadata metadata = super.extractMetadata(extension, mimeType, inputStream);
        boolean forkProcess = false;
        if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains((Object[])PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, (Object)mimeType)) {
            forkProcess = true;
        }
        if (forkProcess) {
            File file = FileUtil.createTempFile();
            try {
                FileUtil.write((File)file, (InputStream)inputStream);
                ExtractMetadataProcessCallable extractMetadataProcessCallable = new ExtractMetadataProcessCallable(file, metadata, this._parser);
                Future future = ProcessExecutor.execute((String)ClassPathUtil.getPortalClassPath(), (ProcessCallable)extractMetadataProcessCallable);
                Metadata metadata2 = (Metadata)future.get();
                return metadata2;
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
            finally {
                file.delete();
            }
        }
        try {
            return TikaRawMetadataProcessor.extractMetadata(inputStream, metadata, this._parser);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    private static class ExtractMetadataProcessCallable
    implements ProcessCallable<Metadata> {
        private static final long serialVersionUID = 1L;
        private File _file;
        private Metadata _metadata;
        private Parser _parser;

        public ExtractMetadataProcessCallable(File file, Metadata metadata, Parser parser) {
            this._file = file;
            this._metadata = metadata;
            this._parser = parser;
        }

        public Metadata call() throws ProcessException {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(this._file);
                Metadata metadata = TikaRawMetadataProcessor.extractMetadata(inputStream, this._metadata, this._parser);
                return metadata;
            }
            catch (IOException ioe) {
                throw new ProcessException((Throwable)ioe);
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException ioe) {
                        throw new ProcessException((Throwable)ioe);
                    }
                }
            }
        }
    }
}

