/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.ResourceBlock;
import com.liferay.portal.model.impl.ResourceBlockModelImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;

public class ResourceBlockModelListener
extends BaseModelListener<ResourceBlock> {
    private static final long _CLEAR_ON_BEFORE_BITMASK = ResourceBlockModelImpl.COMPANYID_COLUMN_BITMASK | ResourceBlockModelImpl.GROUPID_COLUMN_BITMASK | ResourceBlockModelImpl.NAME_COLUMN_BITMASK;

    public void onAfterCreate(ResourceBlock resourceBlock) {
        this._clearCache(resourceBlock);
    }

    public void onAfterRemove(ResourceBlock resourceBlock) {
        this._clearCache(resourceBlock);
    }

    public void onAfterUpdate(ResourceBlock resourceBlock) {
        this._clearCache(resourceBlock);
    }

    public void onBeforeUpdate(ResourceBlock resourceBlock) {
        ResourceBlockModelImpl resourceBlockModelImpl = (ResourceBlockModelImpl)resourceBlock;
        long columnBitmask = resourceBlockModelImpl.getColumnBitmask();
        if ((columnBitmask & _CLEAR_ON_BEFORE_BITMASK) != 0L) {
            PermissionCacheUtil.clearResourceBlockCache(resourceBlockModelImpl.getOriginalCompanyId(), resourceBlockModelImpl.getOriginalGroupId(), resourceBlockModelImpl.getOriginalName());
        }
    }

    private void _clearCache(ResourceBlock resourceBlock) {
        if (resourceBlock != null) {
            PermissionCacheUtil.clearResourceBlockCache(resourceBlock.getCompanyId(), resourceBlock.getGroupId(), resourceBlock.getName());
        }
    }
}

