/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.IgnoreModuleRequestFilter;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicCSSFilter
extends IgnoreModuleRequestFilter {
    public static final boolean ENABLED = GetterUtil.getBoolean((String)PropsUtil.get(DynamicCSSFilter.class.getName()));
    private static final String _CSS_EXTENSION = ".css";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = "css";
    private static Log _log = LogFactoryUtil.getLog(DynamicCSSFilter.class);
    private ServletContext _servletContext;
    private File _tempDir;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        this._tempDir = new File(tempDir, _TEMP_DIR);
        this._tempDir.mkdirs();
        DynamicCSSUtil.init();
    }

    protected String getCacheFileName(HttpServletRequest request) {
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)DynamicCSSFilter.class.getName());
        cacheKeyGenerator.append(HttpUtil.getProtocol((boolean)request.isSecure()));
        cacheKeyGenerator.append("_");
        cacheKeyGenerator.append(request.getRequestURI());
        String queryString = request.getQueryString();
        if (queryString != null) {
            cacheKeyGenerator.append(this.sterilizeQueryString(queryString));
        }
        if (PortalUtil.isRightToLeft((HttpServletRequest)request)) {
            cacheKeyGenerator.append("_rtl");
        }
        return String.valueOf(cacheKeyGenerator.finish());
    }

    protected Object getDynamicContent(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String content;
        String dynamicContent;
        File cacheDataFile;
        block13: {
            URL resourceURL;
            String requestURI;
            String requestPath = requestURI = request.getRequestURI();
            String contextPath = request.getContextPath();
            if (!contextPath.equals("/")) {
                requestPath = requestPath.substring(contextPath.length());
            }
            if ((resourceURL = this._servletContext.getResource(requestPath)) == null) {
                return null;
            }
            URLConnection urlConnection = resourceURL.openConnection();
            String cacheCommonFileName = this.getCacheFileName(request);
            File cacheContentTypeFile = new File(this._tempDir, String.valueOf(cacheCommonFileName) + "_E_CONTENT_TYPE");
            cacheDataFile = new File(this._tempDir, String.valueOf(cacheCommonFileName) + "_E_DATA");
            if (cacheDataFile.exists() && cacheDataFile.lastModified() >= urlConnection.getLastModified()) {
                if (cacheContentTypeFile.exists()) {
                    String contentType = FileUtil.read((File)cacheContentTypeFile);
                    response.setContentType(contentType);
                }
                return cacheDataFile;
            }
            dynamicContent = null;
            content = null;
            try {
                if (requestPath.endsWith(_CSS_EXTENSION)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Parsing SASS on CSS " + requestPath));
                    }
                    content = StringUtil.read((InputStream)urlConnection.getInputStream());
                    dynamicContent = DynamicCSSUtil.parseSass(this._servletContext, request, requestPath, content);
                    response.setContentType("text/css");
                    FileUtil.write((File)cacheContentTypeFile, (String)"text/css");
                    break block13;
                }
                if (requestPath.endsWith(_JSP_EXTENSION)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Parsing SASS on JSP or servlet " + requestPath));
                    }
                    BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
                    this.processFilter(DynamicCSSFilter.class, request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
                    bufferCacheServletResponse.finishResponse(false);
                    content = bufferCacheServletResponse.getString();
                    dynamicContent = DynamicCSSUtil.parseSass(this._servletContext, request, requestPath, content);
                    FileUtil.write((File)cacheContentTypeFile, (String)bufferCacheServletResponse.getContentType());
                    break block13;
                }
                return null;
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to parse SASS on CSS " + requestPath), (Throwable)e2);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)content);
                }
                response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            }
        }
        if (dynamicContent != null) {
            FileUtil.write((File)cacheDataFile, (String)dynamicContent);
        } else {
            dynamicContent = content;
        }
        return dynamicContent;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Object parsedContent = this.getDynamicContent(request, response, filterChain);
        if (parsedContent == null) {
            this.processFilter(DynamicCSSFilter.class, request, response, filterChain);
        } else if (parsedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)response, (File)((File)parsedContent));
        } else if (parsedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)response, (String)((String)parsedContent));
        }
    }

    protected String sterilizeQueryString(String queryString) {
        return StringUtil.replace((String)queryString, (String[])new String[]{"/", "\\"}, (String[])new String[]{"_", "_"});
    }
}

