/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.servicebuilder;

import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.tools.servicebuilder.EntityColumn;
import com.liferay.portal.tools.servicebuilder.EntityFinder;
import com.liferay.portal.tools.servicebuilder.EntityOrder;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Entity {
    public static final String DEFAULT_DATA_SOURCE = "liferayDataSource";
    public static final String DEFAULT_SESSION_FACTORY = "liferaySessionFactory";
    public static final String DEFAULT_TX_MANAGER = "liferayTransactionManager";
    public static final Accessor<Entity, String> NAME_ACCESSOR = new Accessor<Entity, String>(){

        public String get(Entity entity) {
            return entity.getName();
        }
    };
    private String _alias;
    private List<EntityColumn> _blobList;
    private boolean _cacheEnabled;
    private List<EntityColumn> _collectionList;
    private List<EntityColumn> _columnList;
    private boolean _containerModel;
    private String _dataSource;
    private boolean _deprecated;
    private String _finderClass;
    private List<EntityColumn> _finderColumnsList;
    private List<EntityFinder> _finderList;
    private String _humanName;
    private boolean _jsonEnabled;
    private boolean _localService;
    private String _name;
    private EntityOrder _order;
    private String _packagePath;
    private List<String> _parentTransients;
    private String _persistenceClass;
    private List<EntityColumn> _pkList;
    private boolean _portalReference;
    private String _portletName;
    private String _portletShortName;
    private List<Entity> _referenceList;
    private List<EntityColumn> _regularColList;
    private boolean _remoteService;
    private String _sessionFactory;
    private String _table;
    private List<String> _transients;
    private boolean _trashEnabled;
    private String _txManager;
    private List<String> _txRequiredList;
    private boolean _uuid;
    private boolean _uuidAccessor;

    public static EntityColumn getColumn(String name, List<EntityColumn> columnList) {
        for (EntityColumn col : columnList) {
            if (!name.equals(col.getName())) continue;
            return col;
        }
        throw new RuntimeException("Column " + name + " not found");
    }

    public static boolean hasColumn(String name, List<EntityColumn> columnList) {
        return Entity.hasColumn(name, null, columnList);
    }

    public static boolean hasColumn(String name, String type, List<EntityColumn> columnList) {
        int index = columnList.indexOf(new EntityColumn(name));
        if (index != -1) {
            EntityColumn col = columnList.get(index);
            if (type == null || type.equals(col.getType())) {
                return true;
            }
        }
        return false;
    }

    public Entity(String name) {
        this(null, null, null, name, null, null, null, false, false, false, true, null, null, null, null, null, true, false, false, false, null, null, null, null, null, null, null, null, null);
    }

    public Entity(String packagePath, String portletName, String portletShortName, String name, String humanName, String table, String alias, boolean uuid, boolean uuidAccessor, boolean localService, boolean remoteService, String persistenceClass, String finderClass, String dataSource, String sessionFactory, String txManager, boolean cacheEnabled, boolean jsonEnabled, boolean trashEnabled, boolean deprecated, List<EntityColumn> pkList, List<EntityColumn> regularColList, List<EntityColumn> blobList, List<EntityColumn> collectionList, List<EntityColumn> columnList, EntityOrder order, List<EntityFinder> finderList, List<Entity> referenceList, List<String> txRequiredList) {
        this._packagePath = packagePath;
        this._portletName = portletName;
        this._portletShortName = portletShortName;
        this._name = name;
        this._humanName = GetterUtil.getString((String)humanName, (String)ServiceBuilder.toHumanName(name));
        this._table = table;
        this._alias = alias;
        this._uuid = uuid;
        this._uuidAccessor = uuidAccessor;
        this._localService = localService;
        this._remoteService = remoteService;
        this._persistenceClass = persistenceClass;
        this._finderClass = finderClass;
        this._dataSource = GetterUtil.getString((String)dataSource, (String)DEFAULT_DATA_SOURCE);
        this._sessionFactory = GetterUtil.getString((String)sessionFactory, (String)DEFAULT_SESSION_FACTORY);
        this._txManager = GetterUtil.getString((String)txManager, (String)DEFAULT_TX_MANAGER);
        this._cacheEnabled = cacheEnabled;
        this._jsonEnabled = jsonEnabled;
        this._trashEnabled = trashEnabled;
        this._deprecated = deprecated;
        this._pkList = pkList;
        this._regularColList = regularColList;
        this._blobList = blobList;
        this._collectionList = collectionList;
        this._columnList = columnList;
        this._order = order;
        this._finderList = finderList;
        this._referenceList = referenceList;
        this._txRequiredList = txRequiredList;
        if (this._finderList != null) {
            HashSet<EntityColumn> finderColumns = new HashSet<EntityColumn>();
            for (EntityFinder entityFinder : this._finderList) {
                finderColumns.addAll(entityFinder.getColumns());
            }
            this._finderColumnsList = new ArrayList<EntityColumn>(finderColumns);
            Collections.sort(this._finderColumnsList);
        } else {
            this._finderColumnsList = Collections.emptyList();
        }
        if (this._blobList != null && !this._blobList.isEmpty()) {
            for (EntityColumn col : this._blobList) {
                if (col.isLazy()) continue;
                this._cacheEnabled = false;
                break;
            }
        }
        if (this._columnList != null && !this._columnList.isEmpty()) {
            for (EntityColumn col : this._columnList) {
                if (!col.isContainerModel() && !col.isParentContainerModel()) continue;
                this._containerModel = true;
                break;
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)obj;
        String name = entity.getName();
        return this._name.equals(name);
    }

    public String getAlias() {
        return this._alias;
    }

    public List<EntityColumn> getBadNamedColumnsList() {
        List badNamedColumnsList = ListUtil.copy(this._columnList);
        Iterator itr = badNamedColumnsList.iterator();
        while (itr.hasNext()) {
            EntityColumn col = (EntityColumn)itr.next();
            String name = col.getName();
            if (!name.equals(col.getDBName())) continue;
            itr.remove();
        }
        return badNamedColumnsList;
    }

    public List<EntityColumn> getBlobList() {
        return this._blobList;
    }

    public List<EntityFinder> getCollectionFinderList() {
        List finderList = ListUtil.copy(this._finderList);
        Iterator itr = finderList.iterator();
        while (itr.hasNext()) {
            EntityFinder finder = (EntityFinder)itr.next();
            if (finder.isCollection()) continue;
            itr.remove();
        }
        return finderList;
    }

    public List<EntityColumn> getCollectionList() {
        return this._collectionList;
    }

    public EntityColumn getColumn(String name) {
        return Entity.getColumn(name, this._columnList);
    }

    public EntityColumn getColumnByMappingTable(String mappingTable) {
        for (EntityColumn col : this._columnList) {
            if (col.getMappingTable() == null || !col.getMappingTable().equals(mappingTable)) continue;
            return col;
        }
        return null;
    }

    public List<EntityColumn> getColumnList() {
        return this._columnList;
    }

    public String getDataSource() {
        return this._dataSource;
    }

    public EntityColumn getFilterPKColumn() {
        for (EntityColumn col : this._columnList) {
            if (!col.isFilterPrimary()) continue;
            return col;
        }
        return this._getPKColumn();
    }

    public String getFinderClass() {
        return this._finderClass;
    }

    public List<EntityColumn> getFinderColumnsList() {
        return this._finderColumnsList;
    }

    public List<EntityFinder> getFinderList() {
        return this._finderList;
    }

    public String getHumanName() {
        return this._humanName;
    }

    public String getHumanNames() {
        return TextFormatter.formatPlural((String)this._humanName);
    }

    public String getName() {
        return this._name;
    }

    public String getNames() {
        return TextFormatter.formatPlural((String)this._name);
    }

    public EntityOrder getOrder() {
        return this._order;
    }

    public String getPackagePath() {
        return this._packagePath;
    }

    public List<String> getParentTransients() {
        return this._parentTransients;
    }

    public String getPersistenceClass() {
        return this._persistenceClass;
    }

    public String getPKClassName() {
        if (this.hasCompoundPK()) {
            return String.valueOf(this._name) + "PK";
        }
        EntityColumn col = this._getPKColumn();
        return col.getType();
    }

    public String getPKDBName() {
        if (this.hasCompoundPK()) {
            return String.valueOf(this.getVarName()) + "PK";
        }
        EntityColumn col = this._getPKColumn();
        return col.getDBName();
    }

    public List<EntityColumn> getPKList() {
        return this._pkList;
    }

    public String getPKVarName() {
        if (this.hasCompoundPK()) {
            return String.valueOf(this.getVarName()) + "PK";
        }
        EntityColumn col = this._getPKColumn();
        return col.getName();
    }

    public String getPKVarNames() {
        if (this.hasCompoundPK()) {
            return String.valueOf(this.getVarName()) + "PKs";
        }
        EntityColumn col = this._getPKColumn();
        return col.getNames();
    }

    public String getPortletName() {
        return this._portletName;
    }

    public String getPortletShortName() {
        return this._portletShortName;
    }

    public List<Entity> getReferenceList() {
        return this._referenceList;
    }

    public List<EntityColumn> getRegularColList() {
        return this._regularColList;
    }

    public String getSessionFactory() {
        return this._sessionFactory;
    }

    public String getShortName() {
        if (this._name.startsWith(this._portletShortName)) {
            return this._name.substring(this._portletShortName.length());
        }
        return this._name;
    }

    public String getSpringPropertyName() {
        return TextFormatter.format((String)this._name, (int)11);
    }

    public String getTable() {
        return this._table;
    }

    public List<String> getTransients() {
        return this._transients;
    }

    public String getTXManager() {
        return this._txManager;
    }

    public List<String> getTxRequiredList() {
        return this._txRequiredList;
    }

    public List<EntityFinder> getUniqueFinderList() {
        List finderList = ListUtil.copy(this._finderList);
        Iterator itr = finderList.iterator();
        while (itr.hasNext()) {
            EntityFinder finder = (EntityFinder)itr.next();
            if (!finder.isCollection() || finder.isUnique()) continue;
            itr.remove();
        }
        return finderList;
    }

    public String getVarName() {
        return TextFormatter.format((String)this._name, (int)8);
    }

    public String getVarNames() {
        return TextFormatter.formatPlural((String)this.getVarName());
    }

    public boolean hasActionableDynamicQuery() {
        if (this.hasColumns() && this.hasLocalService()) {
            if (this.hasCompoundPK()) {
                EntityColumn col = this._pkList.get(0);
                return col.isPrimitiveType();
            }
            return this.hasPrimitivePK();
        }
        return false;
    }

    public boolean hasArrayableOperator() {
        for (EntityFinder finder : this._finderList) {
            if (!finder.hasArrayableOperator()) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumn(String name) {
        return Entity.hasColumn(name, this._columnList);
    }

    public boolean hasColumn(String name, String type) {
        return Entity.hasColumn(name, type, this._columnList);
    }

    public boolean hasColumns() {
        return this._columnList != null && this._columnList.size() != 0;
    }

    public boolean hasCompoundPK() {
        return this._pkList.size() > 1;
    }

    public boolean hasEagerBlobColumn() {
        if (this._blobList == null || this._blobList.isEmpty()) {
            return false;
        }
        for (EntityColumn col : this._blobList) {
            if (col.isLazy()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFinderClass() {
        return !Validator.isNull((String)this._finderClass);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean hasLazyBlobColumn() {
        if (this._blobList == null || this._blobList.isEmpty()) {
            return false;
        }
        for (EntityColumn col : this._blobList) {
            if (!col.isLazy()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalizedColumn() {
        for (EntityColumn col : this._columnList) {
            if (!col.isLocalized()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalService() {
        return this._localService;
    }

    public boolean hasPrimitivePK() {
        return this.hasPrimitivePK(true);
    }

    public boolean hasPrimitivePK(boolean includeWrappers) {
        if (this.hasCompoundPK()) {
            return false;
        }
        EntityColumn col = this._getPKColumn();
        return col.isPrimitiveType(includeWrappers);
    }

    public boolean hasRemoteService() {
        return this._remoteService;
    }

    public boolean hasUuid() {
        return this._uuid;
    }

    public boolean hasUuidAccessor() {
        return this._uuidAccessor;
    }

    public boolean isAttachedModel() {
        EntityColumn classPKCol;
        String classPKColType;
        if (!this.isTypedModel()) {
            return false;
        }
        return this.hasColumn("classPK") && (classPKColType = (classPKCol = this.getColumn("classPK")).getType()).equals("long");
    }

    public boolean isAuditedModel() {
        return this.hasColumn("companyId") && this.hasColumn("createDate", "Date") && this.hasColumn("modifiedDate", "Date") && this.hasColumn("userId") && this.hasColumn("userName");
    }

    public boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public boolean isContainerModel() {
        return this._containerModel;
    }

    public boolean isDefaultDataSource() {
        return this._dataSource.equals(DEFAULT_DATA_SOURCE);
    }

    public boolean isDefaultSessionFactory() {
        return this._sessionFactory.equals(DEFAULT_SESSION_FACTORY);
    }

    public boolean isDefaultTXManager() {
        return this._txManager.equals(DEFAULT_TX_MANAGER);
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public boolean isGroupedModel() {
        String pkVarName = this.getPKVarName();
        return this.isAuditedModel() && this.hasColumn("groupId") && !pkVarName.equals("groupId");
    }

    public boolean isHierarchicalTree() {
        if (!this.hasPrimitivePK()) {
            return false;
        }
        EntityColumn col = this._getPKColumn();
        return this._columnList.indexOf(new EntityColumn("parent" + col.getMethodName())) != -1 && this._columnList.indexOf(new EntityColumn("left" + col.getMethodName())) != -1 && this._columnList.indexOf(new EntityColumn("right" + col.getMethodName())) != -1;
    }

    public boolean isJsonEnabled() {
        return this._jsonEnabled;
    }

    public boolean isOrdered() {
        return this._order != null;
    }

    public boolean isPermissionCheckEnabled() {
        for (EntityFinder finder : this._finderList) {
            if (!this.isPermissionCheckEnabled(finder)) continue;
            return true;
        }
        return false;
    }

    public boolean isPermissionCheckEnabled(EntityFinder finder) {
        if (this._name.equals("Group") || this._name.equals("User") || finder.getName().equals("UUID_G") || !finder.isCollection() || !this.hasPrimitivePK() || !ResourceActionsUtil.hasModelResourceActions((String)(String.valueOf(this._packagePath) + ".model." + this._name))) {
            return false;
        }
        return !this.hasColumn("groupId") || finder.hasColumn("groupId");
    }

    public boolean isPermissionedModel() {
        return this.hasColumn("resourceBlockId");
    }

    public boolean isPortalReference() {
        return this._portalReference;
    }

    public boolean isResourcedModel() {
        String pkVarName = this.getPKVarName();
        return this.hasColumn("resourcePrimKey") && !pkVarName.equals("resourcePrimKey");
    }

    public boolean isStagedAuditedModel() {
        return this.isAuditedModel() && this.isStagedModel();
    }

    public boolean isStagedGroupedModel() {
        return this.isGroupedModel() && this.isStagedModel();
    }

    public boolean isStagedModel() {
        return this.hasUuid() && this.hasColumn("companyId") && this.hasColumn("createDate", "Date") && this.hasColumn("modifiedDate", "Date");
    }

    public boolean isTrashEnabled() {
        return this._trashEnabled;
    }

    public boolean isTreeModel() {
        return this.hasColumn("treePath");
    }

    public boolean isTypedModel() {
        EntityColumn classNameIdCol;
        String classNameIdColType;
        return this.hasColumn("classNameId") && (classNameIdColType = (classNameIdCol = this.getColumn("classNameId")).getType()).equals("long");
    }

    public boolean isWorkflowEnabled() {
        return this.hasColumn("status") && this.hasColumn("statusByUserId") && this.hasColumn("statusByUserName") && this.hasColumn("statusDate");
    }

    public void setParentTransients(List<String> transients) {
        this._parentTransients = transients;
    }

    public void setPortalReference(boolean portalReference) {
        this._portalReference = portalReference;
    }

    public void setTransients(List<String> transients) {
        this._transients = transients;
    }

    private EntityColumn _getPKColumn() {
        if (this._pkList.isEmpty()) {
            throw new RuntimeException("There is no primary key for entity " + this._name);
        }
        return this._pkList.get(0);
    }
}

