/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.store.BaseStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class S3Store
extends BaseStore {
    private static final String _ACCESS_KEY = PropsUtil.get("dl.store.s3.access.key");
    private static final String _BUCKET_NAME = PropsUtil.get("dl.store.s3.bucket.name");
    private static final String _SECRET_KEY = PropsUtil.get("dl.store.s3.secret.key");
    private static final String _TEMP_DIR_NAME = "/liferay/s3";
    private static final String _TEMP_DIR_PATTERN = "/yyyy/MM/dd/HH/";
    private static Log _log = LogFactoryUtil.getLog(S3Store.class);
    private int _calledGetFileCount;
    private S3Bucket _s3Bucket;
    private S3Service _s3Service;

    public S3Store() {
        try {
            this._s3Service = this.getS3Service();
            this._s3Bucket = this.getS3Bucket();
        }
        catch (S3ServiceException s3se) {
            _log.error((Object)s3se.getMessage());
        }
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) {
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws SystemException {
        try {
            try {
                S3Object s3Object = new S3Object(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, "1.0"));
                s3Object.setDataInputStream(is);
                this._s3Service.putObject(this._s3Bucket, s3Object);
            }
            catch (S3ServiceException s3se) {
                throw new SystemException((Throwable)s3se);
            }
        }
        finally {
            StreamUtil.cleanUp((InputStream)is);
        }
    }

    public void checkRoot(long companyId) {
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) throws SystemException {
        try {
            S3Object[] s3Objects;
            S3Object[] s3ObjectArray = s3Objects = this._s3Service.listObjects(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, dirName), null);
            int n = s3Objects.length;
            int n2 = 0;
            while (n2 < n) {
                S3Object s3Object = s3ObjectArray[n2];
                this._s3Service.deleteObject(this._s3Bucket, s3Object.getKey());
                ++n2;
            }
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws SystemException {
        try {
            S3Object[] s3Objects;
            S3Object[] s3ObjectArray = s3Objects = this._s3Service.listObjects(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, fileName), null);
            int n = s3Objects.length;
            int n2 = 0;
            while (n2 < n) {
                S3Object s3Object = s3ObjectArray[n2];
                this._s3Service.deleteObject(this._s3Bucket, s3Object.getKey());
                ++n2;
            }
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws SystemException {
        try {
            this._s3Service.deleteObject(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, versionLabel));
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        try {
            if (Validator.isNull((String)versionLabel)) {
                versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            }
            S3Object s3Object = this._s3Service.getObject(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, fileName, versionLabel));
            File tempFile = this.getTempFile(s3Object, fileName);
            this.cleanUpTempFiles();
            return tempFile;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (ServiceException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        try {
            if (Validator.isNull((String)versionLabel)) {
                versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            }
            S3Object s3Object = this._s3Service.getObject(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, fileName, versionLabel));
            return s3Object.getDataInputStream();
        }
        catch (ServiceException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId) throws SystemException {
        try {
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket.getName(), this.getKey(companyId, repositoryId), null);
            return this.getFileNames(s3Objects);
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws SystemException {
        try {
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, dirName), null);
            return this.getFileNames(s3Objects);
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        try {
            String versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            StorageObject storageObject = this._s3Service.getObjectDetails(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, fileName, versionLabel));
            return storageObject.getContentLength();
        }
        catch (ServiceException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) {
        return true;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws SystemException {
        try {
            S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, fileName, versionLabel), null);
            return s3Objects.length != 0;
        }
        catch (S3ServiceException s3se) {
            throw new SystemException((Throwable)s3se);
        }
    }

    public void move(String srcDir, String destDir) {
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws SystemException {
        File tempFile = null;
        FileInputStream is = null;
        S3Object newS3Object = null;
        try {
            try {
                S3Object[] s3Objects;
                S3Object[] s3ObjectArray = s3Objects = this._s3Service.listObjects(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, fileName), null);
                int n = s3Objects.length;
                int n2 = 0;
                while (n2 < n) {
                    S3Object oldS3Object = s3ObjectArray[n2];
                    String oldKey = oldS3Object.getKey();
                    oldS3Object = this._s3Service.getObject(this._s3Bucket.getName(), oldKey);
                    tempFile = new File(String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + File.separator + PortalUUIDUtil.generate());
                    FileUtil.write((File)tempFile, (InputStream)oldS3Object.getDataInputStream());
                    is = new FileInputStream(tempFile);
                    String newPrefix = this.getKey(companyId, newRepositoryId);
                    int x = oldKey.indexOf(47);
                    x = oldKey.indexOf(47, x + 1);
                    String newKey = String.valueOf(newPrefix) + oldKey.substring(x);
                    newS3Object = new S3Object(this._s3Bucket, newKey);
                    newS3Object.setDataInputStream((InputStream)is);
                    this._s3Service.putObject(this._s3Bucket, newS3Object);
                    this._s3Service.deleteObject(this._s3Bucket, oldKey);
                    ++n2;
                }
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
            catch (ServiceException se) {
                throw new SystemException((Throwable)se);
            }
        }
        finally {
            StreamUtil.cleanUp(is);
            FileUtil.delete(tempFile);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws SystemException {
        File tempFile = null;
        FileInputStream is = null;
        S3Object newS3Object = null;
        try {
            try {
                S3Object[] s3Objects;
                S3Object[] s3ObjectArray = s3Objects = this._s3Service.listObjects(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, fileName), null);
                int n = s3Objects.length;
                int n2 = 0;
                while (n2 < n) {
                    S3Object oldS3Object = s3ObjectArray[n2];
                    String oldKey = oldS3Object.getKey();
                    oldS3Object = this._s3Service.getObject(this._s3Bucket.getName(), oldKey);
                    tempFile = new File(String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + File.separator + PortalUUIDUtil.generate());
                    FileUtil.write((File)tempFile, (InputStream)oldS3Object.getDataInputStream());
                    oldS3Object.closeDataInputStream();
                    is = new FileInputStream(tempFile);
                    String newPrefix = this.getKey(companyId, repositoryId, newFileName);
                    int x = oldKey.indexOf("/");
                    x = oldKey.indexOf(47, x + 1);
                    x = oldKey.indexOf(47, x + 1);
                    String newKey = String.valueOf(newPrefix) + oldKey.substring(x);
                    newS3Object = new S3Object(this._s3Bucket, newKey);
                    newS3Object.setDataInputStream((InputStream)is);
                    this._s3Service.putObject(this._s3Bucket, newS3Object);
                    this._s3Service.deleteObject(this._s3Bucket, oldKey);
                    ++n2;
                }
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
            catch (ServiceException se) {
                throw new SystemException((Throwable)se);
            }
        }
        finally {
            StreamUtil.cleanUp(is);
            FileUtil.delete(tempFile);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws SystemException {
        try {
            try {
                S3Object s3Object = new S3Object(this._s3Bucket, this.getKey(companyId, repositoryId, fileName, versionLabel));
                s3Object.setDataInputStream(is);
                this._s3Service.putObject(this._s3Bucket, s3Object);
            }
            catch (S3ServiceException s3se) {
                throw new SystemException((Throwable)s3se);
            }
        }
        finally {
            StreamUtil.cleanUp((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpTempFiles() {
        ++this._calledGetFileCount;
        if (this._calledGetFileCount < PropsValues.DL_STORE_S3_TEMP_DIR_CLEAN_UP_FREQUENCY) {
            return;
        }
        S3Store s3Store = this;
        synchronized (s3Store) {
            if (this._calledGetFileCount == 0) {
                return;
            }
            this._calledGetFileCount = 0;
            String tempDirName = String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + _TEMP_DIR_NAME;
            File tempDir = new File(tempDirName);
            long lastModified = System.currentTimeMillis();
            this.cleanUpTempFiles(tempDir, lastModified -= (long)PropsValues.DL_STORE_S3_TEMP_DIR_CLEAN_UP_EXPUNGE * 86400000L);
        }
    }

    protected void cleanUpTempFiles(File file, long lastModified) {
        if (!file.isDirectory()) {
            return;
        }
        String[] fileNames = FileUtil.listDirs((File)file);
        if (fileNames.length == 0) {
            if (file.lastModified() < lastModified) {
                FileUtil.deltree((File)file);
                return;
            }
        } else {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                this.cleanUpTempFiles(new File(file, fileName), lastModified);
                ++n2;
            }
            String[] subfileNames = file.list();
            if (subfileNames.length == 0) {
                FileUtil.deltree((File)file);
                return;
            }
        }
    }

    protected AWSCredentials getAWSCredentials() throws S3ServiceException {
        if (Validator.isNull((String)_ACCESS_KEY) || Validator.isNull((String)_SECRET_KEY)) {
            throw new S3ServiceException("S3 access and secret keys are not set");
        }
        return new AWSCredentials(_ACCESS_KEY, _SECRET_KEY);
    }

    protected String getFileName(String key) {
        int x = key.indexOf(47);
        x = key.indexOf(47, x + 1);
        int y = key.lastIndexOf(47);
        return key.substring(x, y);
    }

    protected String[] getFileNames(S3Object[] s3Objects) {
        ArrayList<String> fileNames = new ArrayList<String>();
        S3Object[] s3ObjectArray = s3Objects;
        int n = s3Objects.length;
        int n2 = 0;
        while (n2 < n) {
            S3Object s3Object = s3ObjectArray[n2];
            String fileName = this.getFileName(s3Object.getKey());
            fileNames.add(fileName);
            ++n2;
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    protected String getHeadVersionLabel(long companyId, long repositoryId, String fileName) throws PortalException, S3ServiceException {
        S3Object[] s3Objects = this._s3Service.listObjects(this._s3Bucket.getName(), this.getKey(companyId, repositoryId, fileName), null);
        Object[] keys = new String[s3Objects.length];
        int i2 = 0;
        while (i2 < s3Objects.length) {
            S3Object s3Object = s3Objects[i2];
            keys[i2] = s3Object.getKey();
            ++i2;
        }
        if (keys.length > 0) {
            Arrays.sort(keys);
            Object headKey = keys[keys.length - 1];
            int x = ((String)headKey).lastIndexOf(47);
            return ((String)headKey).substring(x + 1);
        }
        throw new NoSuchFileException(fileName);
    }

    protected String getKey(long companyId, long repositoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        return sb.toString();
    }

    protected String getKey(long companyId, long repositoryId, String fileName) {
        StringBundler sb = new StringBundler(4);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        sb.append(this.getNormalizedFileName(fileName));
        return sb.toString();
    }

    protected String getKey(long companyId, long repositoryId, String fileName, String versionLabel) {
        StringBundler sb = new StringBundler(6);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        sb.append(this.getNormalizedFileName(fileName));
        sb.append("/");
        sb.append(versionLabel);
        return sb.toString();
    }

    protected String getNormalizedFileName(String fileName) {
        String normalizedFileName = fileName;
        if (!fileName.startsWith("/")) {
            normalizedFileName = "/" + normalizedFileName;
        }
        if (fileName.endsWith("/")) {
            normalizedFileName = normalizedFileName.substring(0, normalizedFileName.length() - 1);
        }
        return normalizedFileName;
    }

    protected S3Bucket getS3Bucket() throws S3ServiceException {
        if (Validator.isNull((String)_BUCKET_NAME)) {
            throw new S3ServiceException("S3 bucket name is not set");
        }
        return this.getS3Service().getBucket(_BUCKET_NAME);
    }

    protected S3Service getS3Service() throws S3ServiceException {
        AWSCredentials credentials = this.getAWSCredentials();
        return new RestS3Service((ProviderCredentials)credentials);
    }

    protected File getTempFile(S3Object s3Object, String fileName) throws IOException, ServiceException {
        StringBundler sb = new StringBundler(5);
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append(_TEMP_DIR_NAME);
        sb.append(DateUtil.getCurrentDate((String)_TEMP_DIR_PATTERN, (Locale)LocaleUtil.getDefault()));
        sb.append(this.getNormalizedFileName(fileName));
        Date lastModifiedDate = s3Object.getLastModifiedDate();
        sb.append(lastModifiedDate.getTime());
        String tempFileName = sb.toString();
        File tempFile = new File(tempFileName);
        if (tempFile.exists() && tempFile.lastModified() >= lastModifiedDate.getTime()) {
            return tempFile;
        }
        InputStream inputStream = s3Object.getDataInputStream();
        if (inputStream == null) {
            throw new IOException("S3 object input stream is null");
        }
        FileOutputStream outputStream = null;
        try {
            File parentFile = tempFile.getParentFile();
            FileUtil.mkdirs((File)parentFile);
            outputStream = new FileOutputStream(tempFile);
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((InputStream)inputStream, outputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)inputStream, (OutputStream)outputStream);
        return tempFile;
    }
}

