/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.MBThreadFlag;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadFlagLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import java.util.Map;

public class MBThreadFlagStagedModelDataHandler
extends BaseStagedModelDataHandler<MBThreadFlag> {
    public static final String[] CLASS_NAMES = new String[]{MBThreadFlag.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws SystemException {
        MBThreadFlag threadFlag = MBThreadFlagLocalServiceUtil.fetchMBThreadFlagByUuidAndGroupId((String)uuid, (long)groupId);
        if (threadFlag != null) {
            MBThreadFlagLocalServiceUtil.deleteThreadFlag((MBThreadFlag)threadFlag);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBThreadFlag threadFlag) throws Exception {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)threadFlag.getThreadId());
        MBMessage rootMessage = MBMessageLocalServiceUtil.getMessage((long)thread.getRootMessageId());
        if (rootMessage.getStatus() != 0 || rootMessage.getCategoryId() == -1L) {
            return;
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)rootMessage);
        Element threadFlagElement = portletDataContext.getExportDataElement((ClassedModel)threadFlag);
        threadFlagElement.addAttribute("root-message-id", String.valueOf(rootMessage.getMessageId()));
        portletDataContext.addClassedModel(threadFlagElement, ExportImportPathUtil.getModelPath((StagedModel)threadFlag), (ClassedModel)threadFlag);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBThreadFlag threadFlag) throws Exception {
        User user = UserLocalServiceUtil.fetchUserByUuidAndCompanyId((String)threadFlag.getUserUuid(), (long)portletDataContext.getCompanyId());
        if (user == null) {
            return;
        }
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)threadFlag);
        long rootMessageId = GetterUtil.getLong((String)element.attributeValue("root-message-id"));
        String rootMessagePath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)MBMessage.class.getName(), (long)rootMessageId);
        MBMessage rootMessage = (MBMessage)portletDataContext.getZipEntryAsObject(rootMessagePath);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)rootMessage);
        Map threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        long threadId = MapUtil.getLong((Map)threadIds, (long)threadFlag.getThreadId(), (long)threadFlag.getThreadId());
        MBThread thread = MBThreadLocalServiceUtil.fetchThread((long)threadId);
        if (thread == null) {
            return;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)threadFlag);
        serviceContext.setUuid(threadFlag.getUuid());
        MBThreadFlagLocalServiceUtil.addThreadFlag((long)user.getUserId(), (MBThread)thread, (ServiceContext)serviceContext);
    }
}

