/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterManager;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDStream
implements COSObjectable {
    private COSStream stream;

    protected PDStream() {
    }

    public PDStream(PDDocument document) {
        this.stream = document.getDocument().createCOSStream();
    }

    public PDStream(COSStream str) {
        this.stream = str;
    }

    public PDStream(PDDocument doc, InputStream str) throws IOException {
        this(doc, str, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDStream(PDDocument doc, InputStream str, boolean filtered) throws IOException {
        OutputStream output = null;
        try {
            this.stream = doc.getDocument().createCOSStream();
            output = filtered ? this.stream.createFilteredStream() : this.stream.createUnfilteredStream();
            byte[] buffer = new byte[1024];
            int amountRead = -1;
            while ((amountRead = str.read(buffer)) != -1) {
                output.write(buffer, 0, amountRead);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (str != null) {
                str.close();
            }
        }
    }

    public void addCompression() {
        List<COSName> filters = this.getFilters();
        if (filters == null) {
            filters = new ArrayList<COSName>();
            filters.add(COSName.FLATE_DECODE);
            this.setFilters(filters);
        }
    }

    public static PDStream createFromCOS(COSBase base) throws IOException {
        PDStream retval = null;
        if (base instanceof COSStream) {
            retval = new PDStream((COSStream)base);
        } else if (base instanceof COSArray) {
            if (((COSArray)base).size() > 0) {
                retval = new PDStream(new COSStreamArray((COSArray)base));
            }
        } else if (base != null) {
            throw new IOException("Contents are unknown type:" + base.getClass().getName());
        }
        return retval;
    }

    @Override
    public COSBase getCOSObject() {
        return this.stream;
    }

    public OutputStream createOutputStream() throws IOException {
        return this.stream.createUnfilteredStream();
    }

    public InputStream createInputStream() throws IOException {
        return this.stream.getUnfilteredStream();
    }

    public InputStream getPartiallyFilteredStream(List<String> stopFilters) throws IOException {
        FilterManager manager = this.stream.getFilterManager();
        InputStream is = this.stream.getFilteredStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        List<COSName> filters = this.getFilters();
        COSName nextFilter = null;
        boolean done = false;
        for (int i = 0; i < filters.size() && !done; ++i) {
            os.reset();
            nextFilter = filters.get(i);
            if (stopFilters.contains(nextFilter.getName())) {
                done = true;
                continue;
            }
            Filter filter = manager.getFilter(nextFilter);
            filter.decode(is, os, this.stream, i);
            is = new ByteArrayInputStream(os.toByteArray());
        }
        return is;
    }

    public COSStream getStream() {
        return this.stream;
    }

    public int getLength() {
        return this.stream.getInt(COSName.LENGTH, 0);
    }

    public List<COSName> getFilters() {
        List<?> retval = null;
        COSBase filters = this.stream.getFilters();
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList<COSName>(name, (COSBase)name, (COSDictionary)this.stream, COSName.FILTER);
        } else if (filters instanceof COSArray) {
            retval = ((COSArray)filters).toList();
        }
        return retval;
    }

    public void setFilters(List<COSName> filters) {
        COSArray obj = COSArrayList.converterToCOSArray(filters);
        this.stream.setItem(COSName.FILTER, (COSBase)obj);
    }

    public List<Object> getDecodeParms() throws IOException {
        COSArrayList<COSDictionaryMap<String, Object>> retval = null;
        COSBase dp = this.stream.getDictionaryObject(COSName.DECODE_PARMS);
        if (dp == null) {
            dp = this.stream.getDictionaryObject(COSName.DP);
        }
        if (dp instanceof COSDictionary) {
            COSDictionaryMap<String, Object> map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList<COSDictionaryMap<String, Object>>(map, dp, (COSDictionary)this.stream, COSName.DECODE_PARMS);
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap<String, Object>> actuals = new ArrayList<COSDictionaryMap<String, Object>>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setDecodeParms(List<?> decodeParams) {
        this.stream.setItem(COSName.DECODE_PARMS, (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    public PDFileSpecification getFile() throws IOException {
        COSBase f = this.stream.getDictionaryObject(COSName.F);
        PDFileSpecification retval = PDFileSpecification.createFS(f);
        return retval;
    }

    public void setFile(PDFileSpecification f) {
        this.stream.setItem(COSName.F, (COSObjectable)f);
    }

    public List<String> getFileFilters() {
        List<String> retval = null;
        COSBase filters = this.stream.getDictionaryObject(COSName.F_FILTER);
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList<String>(name.getName(), (COSBase)name, (COSDictionary)this.stream, COSName.F_FILTER);
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFileFilters(List<String> filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.stream.setItem(COSName.F_FILTER, (COSBase)obj);
    }

    public List<Object> getFileDecodeParams() throws IOException {
        COSArrayList<COSDictionaryMap<String, Object>> retval = null;
        COSBase dp = this.stream.getDictionaryObject(COSName.F_DECODE_PARMS);
        if (dp instanceof COSDictionary) {
            COSDictionaryMap<String, Object> map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList<COSDictionaryMap<String, Object>>(map, dp, (COSDictionary)this.stream, COSName.F_DECODE_PARMS);
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap<String, Object>> actuals = new ArrayList<COSDictionaryMap<String, Object>>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setFileDecodeParams(List<?> decodeParams) {
        this.stream.setItem("FDecodeParams", (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        InputStream is = null;
        try {
            is = this.createInputStream();
            int amountRead = -1;
            while ((amountRead = is.read(buf)) != -1) {
                output.write(buf, 0, amountRead);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return output.toByteArray();
    }

    public String getInputStreamAsString() throws IOException {
        byte[] bStream = this.getByteArray();
        return new String(bStream, "ISO-8859-1");
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSBase mdStream = this.stream.getDictionaryObject(COSName.METADATA);
        if (mdStream != null) {
            if (mdStream instanceof COSStream) {
                retval = new PDMetadata((COSStream)mdStream);
            } else if (!(mdStream instanceof COSNull)) {
                throw new IllegalStateException("Expected a COSStream but was a " + mdStream.getClass().getSimpleName());
            }
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.stream.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getDecodedStreamLength() {
        return this.stream.getInt(COSName.DL);
    }

    public void setDecodedStreamLength(int decodedStreamLength) {
        this.stream.setInt(COSName.DL, decodedStreamLength);
    }
}

