/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayFrontCodedList
extends AbstractObjectList<long[]>
implements Serializable,
Cloneable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected int n;
    protected int ratio;
    protected long[] array;
    protected transient int[] p;

    public LongArrayFrontCodedList(Iterator arrays, int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        long[] array = LongArrays.EMPTY_ARRAY;
        int[] p = IntArrays.EMPTY_ARRAY;
        long[][] a = new long[2][];
        int curSize = 0;
        int b = 0;
        while (arrays.hasNext()) {
            a[b] = (long[])arrays.next();
            int length = a[b].length;
            if (this.n % ratio == 0) {
                p = IntArrays.grow(p, this.n / ratio + 1);
                p[this.n / ratio] = curSize;
                array = LongArrays.grow(array, curSize + LongArrayFrontCodedList.count(length) + length, curSize);
                curSize += LongArrayFrontCodedList.writeInt(array, length, curSize);
                System.arraycopy(a[b], 0, array, curSize, length);
                curSize += length;
            } else {
                int common;
                int minLength = a[1 - b].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a[0][common] == a[1][common]; ++common) {
                }
                array = LongArrays.grow(array, curSize + LongArrayFrontCodedList.count(length -= common) + LongArrayFrontCodedList.count(common) + length, curSize);
                curSize += LongArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += LongArrayFrontCodedList.writeInt(array, common, curSize);
                System.arraycopy(a[b], common, array, curSize, length);
                curSize += length;
            }
            b = 1 - b;
            ++this.n;
        }
        this.ratio = ratio;
        this.array = LongArrays.trim(array, curSize);
        this.p = IntArrays.trim(p, (this.n + ratio - 1) / ratio);
    }

    public LongArrayFrontCodedList(Collection c, int ratio) {
        this(c.iterator(), ratio);
    }

    private static int readInt(long[] a, int pos) {
        return (int)a[pos];
    }

    private static int count(int length) {
        return 1;
    }

    private static int writeInt(long[] a, int length, int pos) {
        a[pos] = length;
        return 1;
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(int index) {
        long[] array = this.array;
        int delta = index % this.ratio;
        int pos = this.p[index / this.ratio];
        int length = LongArrayFrontCodedList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += LongArrayFrontCodedList.count(length) + length;
        length = LongArrayFrontCodedList.readInt(array, pos);
        int common = LongArrayFrontCodedList.readInt(array, pos + LongArrayFrontCodedList.count(length));
        for (int i = 0; i < delta - 1; ++i) {
            length = LongArrayFrontCodedList.readInt(array, pos += LongArrayFrontCodedList.count(length) + LongArrayFrontCodedList.count(common) + length);
            common = LongArrayFrontCodedList.readInt(array, pos + LongArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(int index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(int index, long[] a, int offset, int length) {
        int startPos;
        int delta = index % this.ratio;
        int pos = startPos = this.p[index / this.ratio];
        int arrayLength = LongArrayFrontCodedList.readInt(this.array, pos);
        int currLen = 0;
        if (delta == 0) {
            pos = this.p[index / this.ratio] + LongArrayFrontCodedList.count(arrayLength);
            System.arraycopy(this.array, pos, a, offset, Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i = 0; i < delta; ++i) {
            int prevArrayPos = pos + LongArrayFrontCodedList.count(arrayLength) + (i != 0 ? LongArrayFrontCodedList.count(common) : 0);
            common = LongArrayFrontCodedList.readInt(this.array, (pos = prevArrayPos + arrayLength) + LongArrayFrontCodedList.count(arrayLength = LongArrayFrontCodedList.readInt(this.array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            System.arraycopy(this.array, prevArrayPos, a, currLen + offset, actualCommon - currLen);
            currLen = actualCommon;
        }
        if (currLen < length) {
            System.arraycopy(this.array, pos + LongArrayFrontCodedList.count(arrayLength) + LongArrayFrontCodedList.count(common), a, currLen + offset, Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    @Override
    public long[] get(int index) {
        return this.getArray(index);
    }

    public long[] getArray(int index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        long[] a = new long[length];
        this.extract(index, a, 0, length);
        return a;
    }

    public int get(int index, long[] a, int offset, int length) {
        this.ensureRestrictedIndex(index);
        LongArrays.ensureOffsetLength(a, offset, length);
        int arrayLength = this.extract(index, a, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(int index, long[] a) {
        return this.get(index, a, 0, a.length);
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public ObjectListIterator<long[]> listIterator(final int start) {
        this.ensureIndex(start);
        return new AbstractObjectListIterator<long[]>(){
            long[] a = LongArrays.EMPTY_ARRAY;
            int i = 0;
            int pos = 0;
            boolean inSync;
            {
                if (start != 0) {
                    if (start == LongArrayFrontCodedList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = LongArrayFrontCodedList.this.p[start / LongArrayFrontCodedList.this.ratio];
                        int j = start % LongArrayFrontCodedList.this.ratio;
                        this.i = start - j;
                        while (j-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.i < LongArrayFrontCodedList.this.n;
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public long[] next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i % LongArrayFrontCodedList.this.ratio == 0) {
                    this.pos = LongArrayFrontCodedList.this.p[this.i / LongArrayFrontCodedList.this.ratio];
                    length = LongArrayFrontCodedList.readInt(LongArrayFrontCodedList.this.array, this.pos);
                    this.a = LongArrays.ensureCapacity(this.a, length, 0);
                    System.arraycopy(LongArrayFrontCodedList.this.array, this.pos + LongArrayFrontCodedList.count(length), this.a, 0, length);
                    this.pos += length + LongArrayFrontCodedList.count(length);
                    this.inSync = true;
                } else if (this.inSync) {
                    length = LongArrayFrontCodedList.readInt(LongArrayFrontCodedList.this.array, this.pos);
                    int common = LongArrayFrontCodedList.readInt(LongArrayFrontCodedList.this.array, this.pos + LongArrayFrontCodedList.count(length));
                    this.a = LongArrays.ensureCapacity(this.a, length + common, common);
                    System.arraycopy(LongArrayFrontCodedList.this.array, this.pos + LongArrayFrontCodedList.count(length) + LongArrayFrontCodedList.count(common), this.a, common, length);
                    this.pos += LongArrayFrontCodedList.count(length) + LongArrayFrontCodedList.count(common) + length;
                    length += common;
                } else {
                    length = LongArrayFrontCodedList.this.length(this.i);
                    this.a = LongArrays.ensureCapacity(this.a, length, 0);
                    LongArrayFrontCodedList.this.extract(this.i, this.a, 0, length);
                }
                ++this.i;
                return LongArrays.copy(this.a, 0, length);
            }

            @Override
            public long[] previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return LongArrayFrontCodedList.this.getArray(--this.i);
            }
        };
    }

    public Object clone() {
        LongArrayFrontCodedList c;
        try {
            c = (LongArrayFrontCodedList)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.array = (long[])this.array.clone();
        c.p = (int[])this.p.clone();
        return c;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[ ");
        for (int i = 0; i < this.n; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(LongArrayList.wrap(this.getArray(i)).toString());
        }
        s.append(" ]");
        return s.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int[] p = new int[(this.n + this.ratio - 1) / this.ratio];
        long[] a = this.array;
        int i = 0;
        int pos = 0;
        for (i = 0; i < this.n; ++i) {
            int length = LongArrayFrontCodedList.readInt(a, pos);
            if (i % this.ratio == 0) {
                p[i / this.ratio] = pos;
                pos += LongArrayFrontCodedList.count(length) + length;
                continue;
            }
            int common = LongArrayFrontCodedList.readInt(a, pos + LongArrayFrontCodedList.count(length));
            pos += LongArrayFrontCodedList.count(length) + LongArrayFrontCodedList.count(common) + length;
        }
        this.p = p;
    }
}

