/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.DAMLObjectProperty;
import com.hp.hpl.jena.daml.PropertyAccessor;
import com.hp.hpl.jena.daml.common.DAMLHierarchy;
import com.hp.hpl.jena.daml.common.DAMLPropertyImpl;
import com.hp.hpl.jena.daml.common.PropertyAccessorImpl;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;

public class DAMLObjectPropertyImpl
extends DAMLPropertyImpl
implements DAMLObjectProperty {
    private PropertyAccessor m_propInverseOf = null;

    public DAMLObjectPropertyImpl(String string, String string2, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, string2, dAMLModel, dAMLVocabulary);
        this.setRDFType(this.getVocabulary().ObjectProperty());
    }

    public DAMLObjectPropertyImpl(String string, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, dAMLModel, dAMLVocabulary);
        this.setRDFType(this.getVocabulary().ObjectProperty());
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.indexOf("Impl");
        int n2 = string.lastIndexOf(".") + 1;
        string = n > 0 ? string.substring(n2, n) : string.substring(n2);
        String string2 = this.isUnique() ? "unique " : "";
        string2 = string2 + (this.isTransitive() ? "transitive " : "");
        string2 = string2 + (this.isUnambiguous() ? "unambiguous " : "");
        return this.getURI() == null ? "<" + string2 + "Anonymous " + string + "@" + Integer.toHexString(this.hashCode()) + ">" : "<" + string2 + string + " " + this.getURI() + ">";
    }

    public void setIsTransitive(boolean bl) {
        if (bl) {
            this.setRDFType(this.getVocabulary().TransitiveProperty(), false);
        } else {
            this.removeProperty(RDF.type, this.getVocabulary().TransitiveProperty());
        }
    }

    public boolean isTransitive() {
        return this.hasRDFType(this.getVocabulary().TransitiveProperty()) || DAMLHierarchy.getInstance().isTransitiveProperty(this);
    }

    public void setIsUnambiguous(boolean bl) {
        if (bl) {
            this.setRDFType(this.getVocabulary().UnambiguousProperty(), false);
        } else {
            this.removeProperty(RDF.type, this.getVocabulary().UnambiguousProperty());
        }
    }

    public boolean isUnambiguous() {
        return this.hasRDFType(this.getVocabulary().UnambiguousProperty());
    }

    public PropertyAccessor prop_inverseOf() {
        if (this.m_propInverseOf == null) {
            this.m_propInverseOf = new PropertyAccessorImpl(this.getVocabulary().inverseOf(), this);
        }
        return this.m_propInverseOf;
    }

    Object getKey() {
        return DAML_OIL.Property.getURI();
    }
}

