/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryExecution;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryResults
implements Iterator {
    Iterator queryExecutionIter;
    QueryExecution queryExecution;
    List resultVars;
    ResultBinding currentEnv;
    int rowNumber;
    volatile boolean finished = false;

    public QueryResults(Query query, QueryExecution queryExecution, Iterator iterator) {
        this.queryExecutionIter = iterator;
        this.queryExecution = queryExecution;
        this.resultVars = query.getResultVars();
        this.currentEnv = null;
        this.rowNumber = 0;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("com.hp.hpl.jena.rdf.query.QueryResults.remove");
    }

    public boolean hasNext() {
        return this.queryExecutionIter.hasNext();
    }

    public Object next() {
        this.currentEnv = (ResultBinding)this.queryExecutionIter.next();
        if (this.currentEnv != null) {
            ++this.rowNumber;
        }
        return this.currentEnv;
    }

    public void close() {
        if (!this.finished) {
            this.queryExecution.abort();
            this.finished = true;
        } else {
            this.queryExecution.close();
        }
    }

    public String getBinding(String string) {
        return this.getBindingWorker(string, false);
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public List getAll() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.hasNext()) {
            arrayList.add(this.next());
        }
        return arrayList;
    }

    private String getBindingWorker(String string, boolean bl) {
        if (!bl || this.resultVars.contains(string)) {
            Value value = this.currentEnv.getValue(string);
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        return null;
    }
}

