/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.ErrorHelper;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;

public class PropertyImpl
extends ResourceImpl
implements Property {
    protected int ordinal = 0;

    public PropertyImpl(String string) throws RDFException {
        super(string);
        if (this.localName == null || this.localName.equals("")) {
            throw new RDFException(2);
        }
        this.checkOrdinal();
    }

    public PropertyImpl(String string, String string2) throws RDFException {
        super(string, string2);
        this.checkOrdinal();
    }

    public PropertyImpl(String string, Model model) throws RDFException {
        super(string, model);
        if (this.localName == null || this.localName.equals("")) {
            throw new RDFException(2);
        }
        this.checkOrdinal();
    }

    public PropertyImpl(String string, String string2, Model model) throws RDFException {
        super(string, string2, model);
        this.checkOrdinal();
    }

    public PropertyImpl(String string, String string2, int n, Model model) throws RDFException {
        super(string, string2, model);
        this.ordinal = n;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    protected void checkOrdinal() {
        if (this.localName.charAt(0) == '_' && this.nameSpace.equals(RDF.getURI()) && this.nameSpace.equals(RDF.getURI()) && this.localName.length() > 1) {
            int n = 1;
            while (n < this.localName.length()) {
                char c = this.localName.charAt(n);
                if (c < '0' || c > '9') {
                    return;
                }
                ++n;
            }
            try {
                this.ordinal = Integer.parseInt(this.localName.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorHelper.logInternalError(this.getClass().getName(), 1);
            }
        }
    }

    public Resource port(Model model) throws RDFException {
        if (this.model == model) {
            return this;
        }
        PropertyImpl propertyImpl = new PropertyImpl(this.nameSpace, this.localName, this.ordinal, model);
        propertyImpl.id = this.id;
        return propertyImpl;
    }
}

