/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.compat.portal.kernel.util;

import com.liferay.compat.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LocaleUtil {
    public static final Locale BRAZIL = new Locale("pt", "BR");
    public static final Locale CANADA = Locale.CANADA;
    public static final Locale CANADA_FRENCH = Locale.CANADA_FRENCH;
    public static final Locale CHINA = Locale.CHINA;
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale FRANCE = Locale.FRANCE;
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale GERMANY = Locale.GERMANY;
    public static final Locale HUNGARY = new Locale("hu", "HU");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale ITALY = Locale.ITALY;
    public static final Locale JAPAN = Locale.JAPAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREA = Locale.KOREA;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale NETHERLANDS = new Locale("nl", "NL");
    public static final Locale PORTUGAL = new Locale("pt", "PT");
    public static final Locale PRC = Locale.PRC;
    public static final Locale ROOT = Locale.ROOT;
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale SPAIN = new Locale("es", "ES");
    public static final Locale TAIWAN = Locale.TAIWAN;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.UK;
    public static final Locale US = Locale.US;
    private static Log _log = LogFactoryUtil.getLog(LocaleUtil.class);
    private static LocaleUtil _instance = new LocaleUtil();
    private Locale _locale;
    private Map<String, Locale> _locales = new HashMap<String, Locale>();

    public static boolean equals(Locale locale1, Locale locale2) {
        return com.liferay.portal.kernel.util.LocaleUtil.equals((Locale)locale1, (Locale)locale2);
    }

    public static Locale fromLanguageId(String languageId) {
        return LocaleUtil.getInstance()._fromLanguageId(languageId, true);
    }

    public static Locale fromLanguageId(String languageId, boolean validate) {
        return LocaleUtil.getInstance()._fromLanguageId(languageId, validate);
    }

    public static Locale fromLanguageId(String languageId, boolean validate, boolean useDefault) {
        return LocaleUtil.getInstance()._fromLanguageId(languageId, validate, useDefault);
    }

    public static Locale[] fromLanguageIds(List<String> languageIds) {
        return LocaleUtil.getInstance()._fromLanguageIds(languageIds);
    }

    public static Locale[] fromLanguageIds(String[] languageIds) {
        return LocaleUtil.getInstance()._fromLanguageIds(languageIds);
    }

    public static Locale getDefault() {
        return com.liferay.portal.kernel.util.LocaleUtil.getDefault();
    }

    public static LocaleUtil getInstance() {
        PortalRuntimePermission.checkGetBeanProperty(LocaleUtil.class);
        return _instance;
    }

    public static Map<String, String> getISOLanguages(Locale locale) {
        return com.liferay.portal.kernel.util.LocaleUtil.getISOLanguages((Locale)locale);
    }

    public static String getLongDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return com.liferay.portal.kernel.util.LocaleUtil.getLongDisplayName((Locale)locale, duplicateLanguages);
    }

    public static Locale getMostRelevantLocale() {
        return com.liferay.portal.kernel.util.LocaleUtil.getMostRelevantLocale();
    }

    public static String getShortDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return com.liferay.portal.kernel.util.LocaleUtil.getShortDisplayName((Locale)locale, duplicateLanguages);
    }

    public static Locale getSiteDefault() {
        return com.liferay.portal.kernel.util.LocaleUtil.getSiteDefault();
    }

    public static void setDefault(String userLanguage, String userCountry, String userVariant) {
        com.liferay.portal.kernel.util.LocaleUtil.setDefault((String)userLanguage, (String)userCountry, (String)userVariant);
    }

    public static String toBCP47LanguageId(Locale locale) {
        return com.liferay.portal.kernel.util.LocaleUtil.toBCP47LanguageId((Locale)locale);
    }

    public static String toBCP47LanguageId(String languageId) {
        return com.liferay.portal.kernel.util.LocaleUtil.toBCP47LanguageId((String)languageId);
    }

    public static String[] toBCP47LanguageIds(Locale[] locales) {
        return com.liferay.portal.kernel.util.LocaleUtil.toBCP47LanguageIds((Locale[])locales);
    }

    public static String[] toBCP47LanguageIds(String[] languageIds) {
        return com.liferay.portal.kernel.util.LocaleUtil.toBCP47LanguageIds((String[])languageIds);
    }

    public static String[] toDisplayNames(Locale[] locales, Locale locale) {
        return com.liferay.portal.kernel.util.LocaleUtil.toDisplayNames((Locale[])locales, (Locale)locale);
    }

    public static String toLanguageId(Locale locale) {
        return com.liferay.portal.kernel.util.LocaleUtil.toLanguageId((Locale)locale);
    }

    public static String[] toLanguageIds(Locale[] locales) {
        return com.liferay.portal.kernel.util.LocaleUtil.toLanguageIds((Locale[])locales);
    }

    public static String toW3cLanguageId(Locale locale) {
        return com.liferay.portal.kernel.util.LocaleUtil.toW3cLanguageId((Locale)locale);
    }

    public static String toW3cLanguageId(String languageId) {
        return com.liferay.portal.kernel.util.LocaleUtil.toW3cLanguageId((String)languageId);
    }

    public static String[] toW3cLanguageIds(Locale[] locales) {
        return com.liferay.portal.kernel.util.LocaleUtil.toW3cLanguageIds((Locale[])locales);
    }

    public static String[] toW3cLanguageIds(String[] languageIds) {
        return com.liferay.portal.kernel.util.LocaleUtil.toW3cLanguageIds((String[])languageIds);
    }

    private LocaleUtil() {
        this._locale = new Locale("en", "US");
    }

    private Locale _fromLanguageId(String languageId, boolean validate) {
        return this._fromLanguageId(languageId, validate, true);
    }

    private Locale _fromLanguageId(String languageId, boolean validate, boolean useDefault) {
        Locale locale;
        block10: {
            if (languageId == null) {
                if (useDefault) {
                    return this._locale;
                }
                return null;
            }
            locale = this._locales.get(languageId);
            if (locale != null) {
                return locale;
            }
            try {
                int pos = languageId.indexOf(95);
                if (pos == -1) {
                    locale = new Locale(languageId);
                } else {
                    String[] languageIdParts = StringUtil.split((String)languageId, (char)'_');
                    String languageCode = languageIdParts[0];
                    String countryCode = languageIdParts[1];
                    String variant = null;
                    if (languageIdParts.length > 2) {
                        variant = languageIdParts[2];
                    }
                    locale = Validator.isNotNull(variant) ? new Locale(languageCode, countryCode, variant) : new Locale(languageCode, countryCode);
                }
                if (validate && !LanguageUtil.isAvailableLocale((Locale)locale)) {
                    throw new IllegalArgumentException("Invalid locale " + locale);
                }
                this._locales.put(languageId, locale);
            }
            catch (Exception exception) {
                locale = null;
                if (!_log.isWarnEnabled()) break block10;
                _log.warn((Object)(String.valueOf(languageId) + " is not a valid language id"));
            }
        }
        if (locale == null && useDefault) {
            locale = this._locale;
        }
        return locale;
    }

    private Locale[] _fromLanguageIds(List<String> languageIds) {
        Locale[] locales = new Locale[languageIds.size()];
        int i = 0;
        while (i < languageIds.size()) {
            locales[i] = this._fromLanguageId(languageIds.get(i), true);
            ++i;
        }
        return locales;
    }

    private Locale[] _fromLanguageIds(String[] languageIds) {
        Locale[] locales = new Locale[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            locales[i] = this._fromLanguageId(languageIds[i], true);
            ++i;
        }
        return locales;
    }
}

