/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import java.util.regex.Pattern;

public final class Strings {
    public static final Pattern PARAM_QUOTE_PATTERN = Pattern.compile("[:;,]");
    public static final String LINE_SEPARATOR = "\r\n";

    private Strings() {
    }

    public static String quote(Object aValue) {
        if (aValue != null) {
            return "\"" + aValue + "\"";
        }
        return "\"\"";
    }

    public static String unquote(String aValue) {
        if (aValue != null && aValue.startsWith("\"") && aValue.endsWith("\"")) {
            return aValue.substring(0, aValue.length() - 1).substring(1);
        }
        return aValue;
    }

    public static String escape(String aValue) {
        return Strings.escapePunctuation(Strings.escapeNewline(Strings.escapeBackslash(aValue)));
    }

    public static String unescape(String aValue) {
        return Strings.unescapeBackslash(Strings.unescapeNewline(Strings.unescapePunctuation(aValue)));
    }

    private static String escapePunctuation(String value) {
        if (value != null) {
            return value.replaceAll("([,;])", "\\\\$1");
        }
        return value;
    }

    private static String unescapePunctuation(String value) {
        if (value != null) {
            return value.replaceAll("\\\\([,;\"])", "$1");
        }
        return value;
    }

    private static String escapeNewline(String value) {
        if (value != null) {
            return value.replaceAll("\r?\n", "\\\\n");
        }
        return value;
    }

    private static String unescapeNewline(String value) {
        if (value != null) {
            return value.replaceAll("(?<!\\\\)\\\\n", "\n");
        }
        return value;
    }

    private static String escapeBackslash(String value) {
        if (value != null) {
            return value.replaceAll("\\\\", "\\\\\\\\");
        }
        return value;
    }

    private static String unescapeBackslash(String value) {
        if (value != null) {
            return value.replaceAll("\\\\\\\\", "\\\\");
        }
        return value;
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

