/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.model.User;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.portal.oidc.lr62.JWTCacheProxy;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;

public class IntraVMJWTCacheProxy
extends JWTCacheProxy {
    Map<User, Map<String, String>> oidcTokens;
    Map<User, Map<String, String>> rptTokens;
    private Comparator<User> userComparator = new Comparator<User>(){

        @Override
        public int compare(User u1, User u2) {
            return u1.getScreenName().compareTo(u2.getScreenName());
        }
    };

    protected IntraVMJWTCacheProxy() {
        log.info((Object)"Initializing tokens caches");
        this.oidcTokens = Collections.synchronizedMap(new TreeMap(this.userComparator));
        this.rptTokens = Collections.synchronizedMap(new TreeMap(this.userComparator));
    }

    protected void checkMap(Map<User, Map<String, String>> map, User user) {
        if (!map.containsKey(user)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing map for user: " + user.getScreenName()));
            }
            map.put(user, Collections.synchronizedMap(new TreeMap()));
        }
    }

    @Override
    public void setOIDCToken(User user, String sessionId, JWTToken token) {
        this.checkMap(this.oidcTokens, user);
        Map<String, String> oidcUserMap = this.oidcTokens.get(user);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting OIDC token for user '" + user.getScreenName() + "' and session: " + sessionId));
        }
        oidcUserMap.put(sessionId, JWTTokenUtil.getRawContent(token));
        if (log.isTraceEnabled()) {
            log.trace((Object)("OIDC user's sessions recorded objs: " + oidcUserMap.keySet().toArray()));
        }
    }

    @Override
    public void setUMAToken(User user, String sessionId, JWTToken token) {
        this.checkMap(this.rptTokens, user);
        Map<String, String> umaUserMap = this.rptTokens.get(user);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting UMA token for user '" + user.getScreenName() + "' and session: " + sessionId));
        }
        umaUserMap.put(sessionId, JWTTokenUtil.getRawContent(token));
        if (log.isTraceEnabled()) {
            log.trace((Object)("UMA user's sessions recorded objs: " + umaUserMap.keySet().toArray()));
        }
    }

    @Override
    public JWTToken getOIDCToken(User user, String sessionId) {
        this.checkMap(this.oidcTokens, user);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting OIDC token for user '" + user.getScreenName() + "' and session: " + sessionId));
        }
        return JWTTokenUtil.fromString(this.oidcTokens.get(user).get(sessionId));
    }

    @Override
    public JWTToken getUMAToken(User user, String sessionId) {
        this.checkMap(this.rptTokens, user);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting UMA token for user '" + user.getScreenName() + "' and session: " + sessionId));
        }
        return JWTTokenUtil.fromString(this.rptTokens.get(user).get(sessionId));
    }

    @Override
    public void removeOIDCToken(User user, String sessionId) {
        this.checkMap(this.oidcTokens, user);
        if (this.oidcTokens.get(user).containsKey(sessionId)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing OIDC token for user '" + user.getScreenName() + "' and session: " + sessionId));
            }
            this.oidcTokens.get(user).remove(sessionId);
        } else {
            log.info((Object)("No OIDC token is stored for user '" + user.getScreenName() + "' and session: " + sessionId));
        }
    }

    @Override
    public void removeUMAToken(User user, String sessionId) {
        this.checkMap(this.rptTokens, user);
        if (this.rptTokens.get(user).containsKey(sessionId)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing UMA token for user '" + user.getScreenName() + "' and session: " + sessionId));
            }
            this.rptTokens.get(user).remove(sessionId);
        } else if (log.isTraceEnabled()) {
            log.debug((Object)("No UMA token is stored for user '" + user.getScreenName() + "' and session: " + sessionId));
        }
    }

    @Override
    public void removeAllOIDCTokens(User user) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing all OIDC session's tokens of user: " + user.getScreenName()));
        }
        this.oidcTokens.remove(user);
    }

    @Override
    public void removeAllUMATokens(User user) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing all UMA session's tokens of user: " + user.getScreenName()));
        }
        this.rptTokens.remove(user);
    }

    @Override
    public void clearOIDCTokens() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Clearing OIDC tokens cache");
        }
        this.oidcTokens.clear();
    }

    @Override
    public void clearUMATokens() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Clearing UMA tokens cache");
        }
        this.rptTokens.clear();
    }

    @Override
    public void clearAllTokens() {
        this.clearOIDCTokens();
        this.clearUMATokens();
    }

    @Override
    public synchronized Map<String, String> getMutexFor(User user) {
        this.checkMap(this.oidcTokens, user);
        return this.oidcTokens.get(user);
    }

    @Override
    public void dumpOnLog() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cached OIDC objects: " + this.dumpMap(this.oidcTokens)));
            log.trace((Object)("Cached UMA objects: " + this.dumpMap(this.rptTokens)));
        }
    }

    protected String dumpMap(Map<User, Map<String, String>> map) {
        StringBuffer sb = new StringBuffer();
        map.forEach((u, v) -> {
            sb.append(u.getScreenName() + " :");
            v.forEach((s, t) -> sb.append(" " + s + " -> " + JWTToken.fromString((String)t).getTokenEssentials()));
            sb.append(", ");
        });
        return sb.toString();
    }
}

