/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.util.PortalUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.gcube.oidc.rest.OpenIdConnectConfiguration;

public class LiferayOpenIdConnectConfiguration
implements OpenIdConnectConfiguration {
    protected static final Log log = LogFactoryUtil.getLog(LiferayOpenIdConnectConfiguration.class);
    public static Map<Long, LiferayOpenIdConnectConfiguration> companyId2Configuration = Collections.synchronizedMap(new HashMap());
    private Long companyId;
    private URL authorizationURL;
    private URL tokenURL;
    private URL logoutURL;
    private URL issuerURL;
    private URL avatarURL;
    private String portalClientId;
    private String portalClientSecret;
    private String scope;
    private boolean logoutOnPortalLogout;
    private boolean createUnexistingUser;

    public static synchronized LiferayOpenIdConnectConfiguration getConfiguration(Long companyId) {
        log.trace((Object)"Getting config from companyId");
        if (!companyId2Configuration.containsKey(companyId)) {
            companyId2Configuration.put(companyId, new LiferayOpenIdConnectConfiguration(companyId));
        }
        return companyId2Configuration.get(companyId);
    }

    public static synchronized LiferayOpenIdConnectConfiguration getConfiguration(HttpServletRequest request) {
        log.trace((Object)"Getting config from request");
        return LiferayOpenIdConnectConfiguration.getConfiguration(PortalUtil.getCompanyId((HttpServletRequest)request));
    }

    public static synchronized LiferayOpenIdConnectConfiguration getConfiguration() {
        log.trace((Object)"Getting config from thread local");
        return LiferayOpenIdConnectConfiguration.getConfiguration(CompanyThreadLocal.getCompanyId());
    }

    private LiferayOpenIdConnectConfiguration(Long companyId) {
        log.info((Object)("Creating config from companyId: " + companyId));
        this.companyId = companyId;
        try {
            this.authorizationURL = new URL(PrefsPropsUtil.getString((long)companyId, (String)"d4science.oidc-authorization"));
            this.tokenURL = new URL(PrefsPropsUtil.getString((long)companyId, (String)"d4science.oidc-token"));
            this.logoutURL = new URL(PrefsPropsUtil.getString((long)companyId, (String)"d4science.oidc-logout"));
            this.issuerURL = new URL(PrefsPropsUtil.getString((long)companyId, (String)"d4science.oidc-issuer"));
            this.avatarURL = new URL(PrefsPropsUtil.getString((long)companyId, (String)"d4science.oidc-keycloak_avatar"));
            this.portalClientId = PrefsPropsUtil.getString((long)companyId, (String)"d4science.oidc-portal-client-id");
            this.portalClientSecret = PrefsPropsUtil.getString((long)companyId, (String)"d4science.oidc-portal-client-secret");
            this.scope = PrefsPropsUtil.getString((long)companyId, (String)"d4science.oidc-scope");
            this.logoutOnPortalLogout = PrefsPropsUtil.getBoolean((long)companyId, (String)"d4science.oidc-logout-on-portal-logout");
            this.createUnexistingUser = PrefsPropsUtil.getBoolean((long)companyId, (String)"d4science.oidc-create-unexisting-user");
        }
        catch (SystemException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
        log.debug((Object)("authorizationURL=" + this.getAuthorizationURL()));
        log.debug((Object)("tokenURL=" + this.getTokenURL()));
        log.debug((Object)("logoutURL=" + this.getLogoutURL()));
        log.debug((Object)("issuerURL=" + this.getIssuerURL()));
        log.debug((Object)("avatarURL=" + this.getAvatarURL()));
        log.debug((Object)("portalClientId=" + this.getPortalClientId()));
        log.debug((Object)("portalClientSecret=" + this.getPortalClientSecret().replaceAll("\\w", "*")));
        log.debug((Object)("scope=" + this.getScope()));
        log.debug((Object)("logoutOnPortalLogout=" + this.logoutOnPortalLogout()));
        log.debug((Object)("createUnexistingUser=" + this.createUnexistingUser()));
    }

    public Long getCompanyId() {
        return this.companyId;
    }

    public URL getAuthorizationURL() {
        return this.authorizationURL;
    }

    public URL getTokenURL() {
        return this.tokenURL;
    }

    public URL getLogoutURL() {
        return this.logoutURL;
    }

    public URL getIssuerURL() {
        return this.issuerURL;
    }

    public String getPortalClientId() {
        return this.portalClientId;
    }

    public String getPortalClientSecret() {
        return this.portalClientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean logoutOnPortalLogout() {
        return this.logoutOnPortalLogout;
    }

    public boolean createUnexistingUser() {
        return this.createUnexistingUser;
    }

    public URL getAvatarURL() {
        return this.avatarURL;
    }
}

