/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.portletbridge.ResourceException;
import org.portletbridge.portlet.BridgeFunctionsFactory;
import org.portletbridge.portlet.BridgeTransformer;
import org.portletbridge.portlet.PerPortletMemento;
import org.portletbridge.portlet.PortletBridgeMemento;
import org.portletbridge.portlet.TemplateFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class AltBridgeTransformer
implements BridgeTransformer {
    private TemplateFactory templateFactory = null;
    private XMLReader parser;
    private String servletName;
    private final BridgeFunctionsFactory bridgeFunctionsFactory;

    public AltBridgeTransformer(BridgeFunctionsFactory bridgeFunctionsFactory, TemplateFactory templateFactory, XMLReader parser, String servletName) {
        this.bridgeFunctionsFactory = bridgeFunctionsFactory;
        this.templateFactory = templateFactory;
        this.parser = parser;
        this.servletName = servletName;
    }

    public void transform(PortletBridgeMemento memento, PerPortletMemento perPortletMemento, URI currentUrl, RenderRequest request, RenderResponse response, Reader in) throws ResourceException {
        try {
            PortletPreferences preferences = request.getPreferences();
            String stylesheet = preferences.getValue("stylesheet", null);
            String stylesheetUrl = preferences.getValue("stylesheetUrl", null);
            Templates templates = null;
            templates = stylesheetUrl != null ? this.templateFactory.getTemplatesFromUrl(stylesheetUrl) : this.templateFactory.getTemplatesFromString(stylesheet);
            Transformer transformer = templates.newTransformer();
            transformer.setParameter("bridge", this.bridgeFunctionsFactory.createBridgeFunctions(memento, perPortletMemento, this.servletName, currentUrl, request, response));
            transformer.transform(new SAXSource(this.parser, new InputSource(in)), new StreamResult(response.getWriter()));
        }
        catch (TransformerConfigurationException e) {
            throw new ResourceException("error.transformer", (Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException("error.filter.io", (Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ResourceException("error.transformer", (Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setTemplateFactory(TemplateFactory templateFactory) {
        this.templateFactory = templateFactory;
    }
}

